// This program was written by Jrgen Hoffmann in the year 2009
// and compiled under Borland C++ Version 3.1 using the Small model
//
#include <dos.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <conio.h>
#include <dir.h>

#if defined __TINY__
#define MEMORY_MODEL	"ti"
#elif defined __SMALL__
#define MEMORY_MODEL	"sm"
#elif defined __MEDIUM__
#define MEMORY_MODEL	"me"
#elif defined __COMPACT__
#define MEMORY_MODEL	"co"
#elif defined __LARGE__
#define MEMORY_MODEL	"la"
#else
#define MEMORY_MODEL	"??"
#endif

typedef unsigned short word;            /* 16 bits */
typedef unsigned char  byte;            /*  8 bits */

typedef union {
  unsigned long l;
  byte          b[4];
  } longbyte;

char *version  = "V1.2";

char          errmsg[82]   = "";
byte          use_alternate= 0;
FILE         *infil;
char          caparg[130]  = "";
char          cmdprg[14]   = "ETHDUMP.EXE";
char          cmdarg[80]   = "";
char          cmdlin[130]  = "ETHDUMP /B /F";
char          wrknam[130]  = ".\\ETHSHOW.DMP";
char          filnam[130]  = ".\\ETHSHOW.DMP";
char         *basnam = filnam;
char          pathbuf[130];
unsigned long recpos;
unsigned long maxpos;
word maxnum = 0;
struct {
  word   num;
  word   siz;
  byte   buf[1510];
  word   end;
  } rec;

#define MAXPOS 64
unsigned long rpos[MAXPOS];
word poshift = 0;
word posmask = 0;

byte update  = 0;

//---------------------------------------------------------------

#define ETHERNET_II     1
#define ETHERNET_SNAP   2
#define ETHERNET_802_2  3
#define ETHERNET_802_3  4

#define IPX             1
#define IP              2
#define ARP             3
#define RARP            4
#define NBIOS           5

typedef byte ethernet_address[6];
typedef byte ip_address[4];

typedef struct {
  ethernet_address dst;
  ethernet_address src;
  word             etyp;
  word             dsss;
  byte             ctrl;
  byte             orgacode[3];
  word             styp;
  } ethernet_header;

typedef struct {
  word             hardware;
  word             protocol;
  byte             hlen;
  byte             plen;
  word             opcode;
  ethernet_address hsrc;
  ip_address       psrc;
  ethernet_address hdst;
  ip_address       pdst;
  } arp_header;

typedef struct {
  byte          VersHL;
  byte          Tos;
  word          TLen;
  word          id;
  word          FlgOff;
  byte          ttl;
  byte          prot;
  word          ChsHd;
  ip_address    src;
  ip_address    dst;
  } ip_header;

typedef struct {
  word          src;
  word          dst;
  word          len;
  word          chs;
  } udp_header;

typedef struct {
  word          src;
  word          dst;
  unsigned long seqno;
  unsigned long confno;
  byte          offset;
  byte          code;
  word          window;
  word          chs;
  word          urge;
  } tcp_header;

typedef struct {
  byte          typ;
  byte          code;
  word          chs;
  } icmp_header;


typedef struct {
  word             chs;
  word             len;
  byte             tcl;
  byte             typ;
  unsigned long    dstnet;
  ethernet_address dstnode;
  word             dstsock;
  unsigned long    srcnet;
  ethernet_address srcnode;
  word             srcsock;
  } ipx_header;

typedef struct {
  byte             cc;
  byte             dstyp;
  word             srcid;
  word             dstid;
  word             seqnum;
  word             acqnum;
  word             alloc;
  } spx_header;

typedef struct {
  word             len;
  word             delim;
  byte             command;
  byte             data1;
  word             data2;
  word             xmircor;
  word             respcor;
  byte             dst[16];
  byte             src[16];
  } netbios_header;

void            *hdp;
word             hdl;
ethernet_header *enh;
arp_header      *arh;
ip_header       *ihd;
udp_header      *uhd;
tcp_header      *thd;
icmp_header     *ich;
ipx_header      *pxh;
spx_header      *sxh;
netbios_header  *nbh;

word frame_type;
word protocol_type;
word protocol_code;

char *ftypes[5] = { "???", "II", "SNAP", "802.2", "802.3" };
char *ptypes[5] = { "???", "IPX:", "IP:", "ARP:", "RARP:" };

ethernet_address broadcast = { 0XFF,0XFF,0XFF,0XFF,0XFF,0XFF };

word dmpoff = 0;
word dmplim = 160;
char possible_searches[32];
struct {
  word             mode;
  word             fr_typ;
  word             pr_typ;
  word             pr_cod;
  word             pr_sub;
  ethernet_address ead1;
  ethernet_address ead2;
  ip_address       iad1;
  ip_address       iad2;
  ethernet_address xad1;
  ethernet_address xad2;
  unsigned long    xnod1;
  unsigned long    xnod2;
  word             port;
  } srch;

int   datcmd    =  0;
int   datptr    = -1;
int   datwid    =  0;
int   autowid   =  0;
int   hlptr     = -1;
char  hdstr[64] = "";
char  ethhlp[]  = "\03\04\05";
char  llchlp[]  = "\06";
char  snphlp[]  = "\06\07";
char  ipxhlp[]  = "\010\011\012\013\014\015\016\017\020\021";
char  spxhlp[]  = "\022\023\024\025\026\027\030";
char  arphlp[]  = "\031\032\033\034\035\036\037\040\041";
char  iphlp[]   = "\042\043\044\045\046\047\050\051\052\053";
char  icmhlp[]  = "\054\055\010";
char  tcphlp[]  = "\056\057\060\061\062\063\064\010\065";
char  udphlp[]  = "\056\057\011\010";
char  nb1hlp[]  = "\066\067\070\071\072\073\074\075\076";
char  nb2hlp[]  = "\066\067\070\071\072\073\074\077\0100";
char *hdhlp[]   = { "",
		    " IP options",
		    " TCP options",
      /* 003 */     "\06Ethernet destination address",
      /* 004 */	    "\06Ethernet source address",
      /* 005 */	    "\02Ethernet type or data length",
      /* 006 */	    "\03LLC header: DSAP SSAP and Control",
      /* 007 */	    "\05SNAP header: orga code and Ethertype",
      /* 010 */	    "\02Checksum",
      /* 011 */	    "\02Lenght",
      /* 012 */	    "\01Transport Control",
      /* 013 */	    "\01Packet type",
      /* 014 */	    "\04Destination network",
      /* 015 */	    "\06Destination host",
      /* 016 */	    "\02Destination socket",
      /* 017 */	    "\04Source network",
      /* 020 */	    "\06Source host",
      /* 021 */	    "\02Source socket",
      /* 022 */     "\01Connection control",
      /* 023 */     "\01Datastream type",
      /* 024 */     "\02Source connection ID",
      /* 025 */     "\02Destination connection ID",
      /* 026 */     "\02Sequence number",
      /* 027 */     "\02Acknowledge number",
      /* 030 */     "\02Allocation number",
      /* 031 */     "\02Hardware type",
      /* 032 */     "\02Protocol type",
      /* 033 */     "\01Hardware address length",
      /* 034 */     "\01Protocol address length",
      /* 035 */     "\02Operation code",
      /* 036 */     "\06Sender MAC address",
      /* 037 */     "\04Sender IP address",
      /* 040 */     "\06Receiver MAC address",
      /* 041 */     "\04Receiver IP address",
      /* 042 */     "\01IP version and header length",
      /* 043 */     "\01Type of service",
      /* 044 */     "\02Total length",
      /* 045 */     "\02Datagram ID",
      /* 046 */     "\02Flags and fragment offset",
      /* 047 */     "\01Time to live",
      /* 050 */     "\01Sub-protocol",
      /* 051 */     "\02Header checksum",
      /* 052 */     "\04Source IP address",
      /* 053 */     "\04Destination IP address",
      /* 054 */     "\01ICMP type",
      /* 055 */     "\01ICMP code",
      /* 056 */     "\02Source port",
      /* 057 */     "\02Destination port",
      /* 060 */     "\04Sequence number",
      /* 061 */     "\04Acknowledge number",
      /* 062 */     "\01Offset to begin of data",
      /* 063 */     "\01Flags",
      /* 064 */     "\02Window size",
      /* 065 */     "\02Urgent pointer",
      /* 066 */     "\02NetBIOS header length",
      /* 067 */     "\02Deliminator",
      /* 070 */     "\01NetBIOS Command",
      /* 071 */     "\01Data1",
      /* 072 */     "\02Data2",
      /* 073 */     "\02XMIT correlator",
      /* 074 */     "\02Response correlator",
      /* 075 */     "\020Destination name",
      /* 076 */     "\020Source name",
      /* 077 */     "\01Destination ID",
      /* 100 */     "\02Source ID",
		    NULL };


word swap(word arg) {
  return((arg & 0xFF00) >> 8) | ((arg & 0xFF) << 8);
  }

unsigned long lswap(unsigned long arg) {
  longbyte a,r;
  a.l = arg;
  r.b[0] = a.b[3];
  r.b[1] = a.b[2];
  r.b[2] = a.b[1];
  r.b[3] = a.b[0];
  return(r.l);
  }

//----- various utilities ---------------------------------------

word htoi(char *p, int count) {
  word i;
  for(i=0; *p && count; p++,count--) {
    if(!isxdigit(*p)) break;
    i <<= 4;
    if(isdigit(*p)) i |= (*p&0x0F);
    else i |= ((*p&0X0F) + 9);
    }
  return(i);
  }

char *h2str(byte *p, int len, int sep) {
  static char temp[20];
  char *p2;
  int i,j;
  if(len>6) len = 6;
  for(i=0,j=0,p2=temp; i<len; i++,j++,p++) {
    if(j==sep) {
      *p2++ = ':';
      j = 0;
      }
    sprintf(p2,"%02X",*p);
    p2 += 2;
    }
  *p2 = '\0';
  return(temp);
  }

char *ipad2str(byte *p) {
  static char temp[20];
  sprintf(temp,"%d.%d.%d.%d",p[0],p[1],p[2],p[3]);
  return(temp);
  }

char *bin2str(byte b) {
  static char temp[10];
  word mask,i;
  for(i=0,mask=0X80; mask; i++,mask>>=1) temp[i] = (b&mask)?'1':'0';
  temp[i++] = ' ';
  temp[i]   = '\0';
  return(temp);
  }

//----- random file access --------------------------------------

int isopen(FILE *stream) {
  return((stream!=NULL)&&(fileno(stream)>=5)&&(fileno(stream)<=SYS_OPEN));
  }

void re_organize(void) {
  word i,j;
  for(i=j=0; j<MAXPOS; i++, j+=2) rpos[i] = rpos[j];
  posmask = (1 << ++poshift) - 1;
  }

void next_record(void) {
  word r;
  if(!isopen(infil)) return;
  if(feof(infil)) return;
  recpos = ftell(infil);
  fread(&rec.num,sizeof(word),2,infil);
  if(rec.siz>sizeof(rec.buf)) {
    sprintf(errmsg,"ERROR: bad size: %d in record: %d offset: %lu",rec.siz,rec.num,recpos);
    fclose(infil);
    }
  else {
    fread(&rec.buf,sizeof(byte),rec.siz,infil);
    if(rec.num>maxnum) {
      maxnum = rec.num;
      maxpos = recpos;
      r = rec.num >> poshift;
      if(r>=MAXPOS) {
	re_organize();
	r = rec.num >> poshift;
	}
      if(!(rec.num&posmask)) rpos[r] = recpos;
      }
    }
  dmpoff = datwid = autowid = datcmd = 0;
  hlptr  = datptr = -1;
  rec.end = 0;
  if(rec.siz<sizeof(rec.buf)-1) rec.buf[rec.siz] = 0;
  }

void read_record(word recnum) {
  if(!isopen(infil)) return;
  if(recnum<=maxnum) fseek(infil,rpos[recnum>>poshift],SEEK_SET);
  else fseek(infil,maxpos,SEEK_SET);
  do { next_record(); } while(!feof(infil)&&(rec.num<recnum));
  }

//----- protocol analysis ---------------------------------------

void check_frame(void) {
  hdl = 14;
  strcpy(hdstr,ethhlp);
  enh = (ethernet_header *)&rec.buf;
  frame_type = protocol_type = protocol_code = 0;
  if(swap(enh->etyp) > 1500) {
    frame_type    = ETHERNET_II;
    protocol_code = swap(enh->etyp);
    }
  else if(enh->dsss==0XAAAA) {
    frame_type    = ETHERNET_SNAP;
    protocol_code = swap(enh->styp);
    hdl = 22;
    strcat(hdstr,snphlp);
    }
  else if(((enh->dsss!=0)&&(enh->dsss!=0XFFFF)&&(enh->dsss==swap(enh->dsss)))
       || ((enh->dsss==0)&&(enh->ctrl==3))) {
    frame_type    = ETHERNET_802_2;
    protocol_code = enh->dsss;
    if(protocol_code==0XE0E0) protocol_type = IPX;
    if((protocol_code==0)&&(rec.buf[17]==0XFF)&&(rec.buf[18]==0XFF)
    &&(!memcmp(enh->dst,&rec.buf[27],6)||!memcmp(enh->src,&rec.buf[39],6))) protocol_type = IPX;
    hdl = 17;
    strcat(hdstr,llchlp);
    }
  else if((enh->dsss==0XFFFF)
       &&(!memcmp(enh->dst,&rec.buf[24],6)
       || !memcmp(enh->src,&rec.buf[36],6) )) {
    frame_type    = ETHERNET_802_3;
    protocol_type = IPX;
    }
  if((frame_type==ETHERNET_II)||(frame_type==ETHERNET_SNAP)) {
    switch(protocol_code) {
      case 0X0800: protocol_type = IP;    break;
      case 0X0806: protocol_type = ARP;   break;
      case 0X8035: protocol_type = RARP;  break;
      case 0X8137: protocol_type = IPX;   break;
      }
    }
  hdp = &rec.buf[hdl];
  }

void check_protocol(void) {
  int i;
  switch(protocol_type) {
    case IP:     ihd = (ip_header *)hdp;
		 i   = (((ihd->VersHL)&0XF)<<2);
		 hdl += i;
		 strcat(hdstr,iphlp);
		 if(i>sizeof(ip_header)) {
		   i -= sizeof(ip_header);
		   hdhlp[1][0] = i&=0XFF;
		   strcat(hdstr,"\01");
		   }
		 if(ihd->prot==1) {
		   ich = (icmp_header *)&rec.buf[hdl];
		   hdl += sizeof(icmp_header);
		   strcat(hdstr,icmhlp);
		   }
		 else if(ihd->prot==6) {
		   thd = (tcp_header *)&rec.buf[hdl];
		   i = ((thd->offset&0XF0)>>2);
		   hdl += i;
		   strcat(hdstr,tcphlp);
		   if(i>sizeof(tcp_header)) {
		     i -= sizeof(tcp_header);
		     hdhlp[2][0] = i&=0XFF;
		     strcat(hdstr,"\02");
		     }
		   }
		 else if(ihd->prot==17) {
		   uhd = (udp_header *)&rec.buf[hdl];
		   hdl += sizeof(udp_header);
		   strcat(hdstr,udphlp);
		   }
		 break;
    case ARP:
    case RARP:   arh = (arp_header *)hdp;
		 hdl += sizeof(arp_header);
		 strcat(hdstr,arphlp);
		 break;
    case IPX:    pxh = (ipx_header *)hdp;
		 hdl += sizeof(ipx_header);
		 strcat(hdstr,ipxhlp);
		 if(pxh->typ==0X05) {
		   sxh = (spx_header *)&rec.buf[hdl];
		   hdl += sizeof(spx_header);
		   strcat(hdstr,spxhlp);
		   }
		 break;
    default:     if((frame_type==ETHERNET_802_2)&&(protocol_code==0XF0F0)
		 &&(rec.buf[hdl+2]==0XFF)&&(rec.buf[hdl+3]==0XEF))
		   if((rec.buf[hdl]==44)||(rec.buf[hdl]==14)) {
		     if(rec.buf[hdl]==44) strcat(hdstr,nb1hlp);
		     else strcat(hdstr,nb2hlp);
		     protocol_type = NBIOS;
		     nbh = (netbios_header *)&rec.buf[hdl];
		     hdl += rec.buf[hdl];
		     }
		 break;
    }
  }

char *shport(word num) {
  static char tmp[20];
  char *p;
  word prt;
  prt = swap(num);
  sprintf(tmp,"%d",prt);
  p = &tmp[strlen(tmp)];
  switch(prt) {
    case  20: sprintf(p," (FTP-DATA)");  break;
    case  21: sprintf(p," (FTP)");       break;
    case  23: sprintf(p," (TELNET)");    break;
    case  25: sprintf(p," (SMTP)");      break;
    case  53: sprintf(p," (DNS)");       break;
    case  69: sprintf(p," (TFTP)");      break;
    case  80: sprintf(p," (HTTP)");      break;
    case 110: sprintf(p," (POP3)");      break;
    case 119: sprintf(p," (NNTP)");      break;
    case 137: sprintf(p," (NB-Name)");   break;
    case 138: sprintf(p," (NB-Data)");   break;
    case 139: sprintf(p," (NB-Sess)");   break;
    case 161: sprintf(p," (SNMP)");      break;
    case 162: sprintf(p," (SNMP-TRP)");  break;
    case 389: sprintf(p," (LDAP)");      break;
    case 443: sprintf(p," (HTTPS)");     break;
    case 515: sprintf(p," (LPD)");       break;
    }
  return(tmp);
  }

void show_header(void) {
  int i;
  printf("FRAME: DST=%-15s ",h2str(enh->dst,6,3));
  printf("SRC=%-15s ",h2str(enh->src,6,3));
  if(frame_type==ETHERNET_II) printf("TYP=%s\n",h2str((byte *)&enh->etyp,2,9));
  else {
    printf("Len=%d ",swap(enh->etyp));
    if(frame_type==ETHERNET_802_2) printf("LLC=%s",h2str(&rec.buf[14],3,1));
    else if(frame_type==ETHERNET_SNAP) {
      printf("SNAP=%s ",h2str(&rec.buf[14],3,9));
      printf("%s ",h2str(&rec.buf[17],3,9));
      printf("%s",h2str(&rec.buf[20],2,9));
      }
    printf("\n");
    }
  if(protocol_type==IP) {
    printf("%-6s DST=%-15s",ptypes[protocol_type],ipad2str((byte *)&ihd->dst));
    printf(" SRC=%-15s TTL=%d",ipad2str((byte *)&ihd->src),ihd->ttl);
    printf(" ID=%04X:%u\n",swap(ihd->id),swap(ihd->FlgOff)&0X1FFF);
    if(ihd->prot==1) {
      printf("ICMP:  TYP=%d  Code=%d",ich->typ,ich->code);
      switch(ich->typ) {
	case  0: printf("  echo reply");   break;
	case  8: printf("  echo request"); break;
	case  3: switch(ich->code) {
	  case  0: printf("  network unreachable"); break;
	  case  1: printf("  host unreachable"); break;
	  default: printf("  destination unreachable"); break;
	  }
	}
      printf("\n");
      }
    else if(ihd->prot==6) {
      printf("TCP:   DST=%-15s",shport(thd->dst));
      printf(" SRC=%-15s",shport(thd->src));
      if(thd->code&32) printf(" URG");
      if(thd->code&16) printf(" ACK");
      if(thd->code&8)  printf(" PSH");
      if(thd->code&4)  printf(" RST");
      if(thd->code&2)  printf(" SYN");
      if(thd->code&1)  printf(" FIN");
      printf("\n");
      }
    else if(ihd->prot==17) {
      printf("UDP:   DST=%-15s",shport(uhd->dst));
      printf(" SRC=%-15s\n",shport(uhd->src));
      }
    else printf("???:  unknown sub-protocol code: %d\n",ihd->prot);
    }
  else if((protocol_type==ARP)||(protocol_type==RARP)) {
    printf("%-6s %s",ptypes[protocol_type],((swap(arh->opcode)&1)?"requ":"resp"));
    printf(" DST=%s-%s",h2str((byte *)&arh->hdst,6,3),ipad2str((byte *)&arh->pdst));
    printf(" SRC=%s-%s\n",h2str((byte *)&arh->hsrc,6,3),ipad2str((byte *)&arh->psrc));
    }
  else if(protocol_type==IPX) {
    printf("%-6s DST=%08lX-%s-%04X",ptypes[protocol_type],lswap(pxh->dstnet),
		       h2str((byte *)&pxh->dstnode,6,3),swap(pxh->dstsock));
    printf(" SRC=%08lX-%s-%04X TYP=%02X\n",lswap(pxh->srcnet),
	      h2str((byte *)&pxh->srcnode,6,3),swap(pxh->srcsock),pxh->typ);
    if(pxh->typ==0X05)
      printf("SPX:  DST=%04X  SRC=%04X  SEQ=%04X  ACQ=%04X\n",
	swap(sxh->dstid),swap(sxh->srcid),swap(sxh->seqnum),swap(sxh->acqnum));
    }
  else if(protocol_type==NBIOS) {
    printf("NBIOS: DST=");
    if(nbh->len==44) {
      for(i=0; i<15; i++)
	printf("%c",((nbh->dst[i]>=' ')&&(nbh->dst[i]<='~'))?nbh->dst[i]:'');
      printf(" SRC=");
      for(i=0; i<15; i++)
	printf("%c",((nbh->src[i]>=' ')&&(nbh->src[i]<='~'))?nbh->src[i]:'');
      }
    else printf("ID:%-12d SRC=ID:%-12d",nbh->dst[0],nbh->dst[1]);
    printf(" Cmd=%02X ",nbh->command);
    }
  else if((frame_type==ETHERNET_II)||(frame_type==ETHERNET_SNAP)) {
    switch(protocol_code) {
      case 0X0805: printf("X25: ");                         break;
      case 0X809B: printf("AppleTalk: ");                   break;
      case 0X6001: printf("DECnet: ");                      break;
      case 0X6004: printf("DEC LAT: ");                     break;
      default:     printf("???: Code=%04X ",protocol_code); break;
      }
    printf("(no details)\n");
    }
  else if(frame_type==ETHERNET_802_2) {
      {
      switch(protocol_code&0XFF) {
	case 0X04: printf("SNA: ");                                break;
	case 0X06: printf("DoD IP: ");                             break;
	case 0XF0: printf("NetBIOS: ");                            break;
	case 0XF4: printf("LANMAN: ");                             break;
	default:   printf("???: Code=%02X ",(protocol_code&0XFF)); break;
	}
      printf("(no details)\n");
      }
    }
  }

//----- record search routines ----------------------------------

void search_dialog(void) {
  int i,j,k,l;
  char *p, c, reply[20];
  srch.mode = 0;
  p  = possible_searches;
  *p = '\0';
  k  = ((hdl + 23) / 24) + 7;
  gotoxy(1,23);
  cprintf("%-65s\r","");
  gotoxy(1,k);
  cprintf("%-75s","Find all records ...");
   c = (frame_type)?'A':'S';
   for(l=k+1; l<23; c++) {
    gotoxy(1,l);
    cprintf("%-75s\r","");
    switch(c) {
      case 'A': l++;  *p++ = c;
		cprintf(" %c: of frametype: Ethernet_%s",c,ftypes[frame_type]);
		break;
      case 'B': if(protocol_code) { l++;  *p++ = c;
		cprintf(" %c: of frametype: Ethernet_%s and protocol code: %04X",
			 c,ftypes[frame_type],protocol_code);
		  }
		break;
      case 'C': if(protocol_type==IP) { l++; *p++ = c;
		  cprintf(" %c: of frametype: Ethernet_%s and (sub-)protocol %s%d",
			  c,ftypes[frame_type],ptypes[protocol_type],ihd->prot);
		  }
		break;
      case 'D': l++;  *p++ = c;
		cprintf(" %c: to or from Ethernet address: %s",c,h2str(enh->dst,6,3));
		break;
      case 'E': l++;  *p++ = c;
		cprintf(" %c: to or from Ethernet address: %s",c,h2str(enh->src,6,3));
		break;
      case 'F': l++;  *p++ = c;
		cprintf(" %c: from %s",c,h2str(enh->src,6,3));
		cprintf(" to %s or vice versa",h2str(enh->dst,6,3));
		break;
      case 'G': if(protocol_type==IP) { l++; *p++ = c;
		  cprintf(" %c: to or from IP address: %s",c,ipad2str((byte *)&ihd->dst));
		  }
		break;
      case 'H': if(protocol_type==IP) { l++; *p++ = c;
		  cprintf(" %c: to or from IP address: %s",c,ipad2str((byte *)&ihd->src));
		  }
		break;
      case 'I': if(protocol_type==IP) { l++; *p++ = c;
		  cprintf(" %c: from %s",c,ipad2str((byte *)&ihd->dst));
		  cprintf(" to %s or vice versa",ipad2str((byte *)&ihd->src));
		  }
		break;
      case 'J': if(protocol_type==IPX) { l++; *p++ = c;
		  cprintf(" %c: to or from IPX address: %08lX-%s",c,
		    lswap(pxh->dstnet),h2str((byte *)&pxh->dstnode,6,3));
		  }
		break;
      case 'K': if(protocol_type==IPX) { l++; *p++ = c;
		  cprintf(" %c: to or from IPX address: %08lX-%s",c,
		    lswap(pxh->srcnet),h2str((byte *)&pxh->srcnode,6,3));
		  }
		break;
      case 'L': if(protocol_type==IPX) { l++; *p++ = c;
		  cprintf(" %c: from %08lX-%s",c,lswap(pxh->dstnet),h2str((byte *)&pxh->dstnode,6,3));
		  cprintf(" to %08lX-%s or vice versa",lswap(pxh->srcnet),h2str((byte *)&pxh->srcnode,6,3));
		  }
		break;
      case 'M': if((protocol_type==IP)&&(ihd->prot==6)) { l++; *p++ = c;
		  cprintf(" %c: to or from TCP port: %d",c,swap(thd->dst));
		  }
		break;
      case 'N': if((protocol_type==IP)&&(ihd->prot==6)) { l++; *p++ = c;
		  cprintf(" %c: to or from TCP port: %d",c,swap(thd->src));
		  }
		break;
      case 'O': if((protocol_type==IP)&&(ihd->prot==17)) { l++; *p++ = c;
		  cprintf(" %c: to or from UDP port: %d",c,swap(uhd->dst));
		  }
		break;
      case 'P': if((protocol_type==IP)&&(ihd->prot==17)) { l++; *p++ = c;
		  cprintf(" %c: to or from UDP port: %d",c,swap(uhd->src));
		  }
		break;
      case 'Q': if(protocol_type==IPX) { l++; *p++ = c;
		  cprintf(" %c: to or from IPX socket: %04X",c,swap(pxh->dstsock));
		  }
		break;
      case 'R': if(protocol_type==IPX) { l++; *p++ = c;
		  cprintf(" %c: to or from IPX socket: %04X",c,swap(pxh->srcsock));
		  }
		break;
      case 'S': if(l<22) { l++; *p++ = c;
		  cprintf(" %c: to or from port: ???",c);
		  }
		break;
      case 'T': if(l<22) { l++; *p++ = c;
		  cprintf(" %c: with protocol code: ???",c);
		  }
		break;
      case 'U': if(l<22) { l++; *p++ = c;
		  cprintf(" %c: to the broadcast address",c);
		  }
		break;
      default:  l++;
      }
    }
  *p++ = 27;
  *p   = '\0';
  c = '\0';
  cprintf("enter selection (or <ESC>) please: ");
  do {
    if(kbhit()) {
      i = toupper(getch());
      p = strchr(possible_searches,i);
      if(p) c = *p;
      }
    } while(!c);
  while(kbhit()) i = getch(); // remove extra characters
  update++;
  if(c==27) return;
  cprintf("%c",c);
  reply[0] = 18;
  if((c=='S')||(c=='T')) {
    gotoxy(1,22);
    if(c=='S') cprintf("%-40s\renter port number (31 or 0X1F) please: ","");
    else cprintf("%-40s\renter protocol code (hex) please: ","");
    cgets(reply);
    if(!reply[1]) return;
    }
  srch.mode   = c;
  srch.fr_typ = frame_type;
  srch.pr_typ = protocol_type;
  srch.pr_cod = protocol_code;
  switch(c) {
    case 'C': srch.pr_sub = ihd->prot; break;
    case 'D': memcpy(srch.ead1,enh->dst,sizeof(ethernet_address)); break;
    case 'E': memcpy(srch.ead1,enh->src,sizeof(ethernet_address)); break;
    case 'F': memcpy(srch.ead1,enh->dst,sizeof(ethernet_address));
	      memcpy(srch.ead2,enh->src,sizeof(ethernet_address)); break;
    case 'G': memcpy(srch.iad1,ihd->dst,sizeof(ip_address));       break;
    case 'H': memcpy(srch.iad1,ihd->src,sizeof(ip_address));       break;
    case 'I': memcpy(srch.iad1,ihd->dst,sizeof(ip_address));
	      memcpy(srch.iad2,ihd->src,sizeof(ip_address));       break;
    case 'J': memcpy(srch.xad1,pxh->dstnode,sizeof(ethernet_address));
	      srch.xnod1 = pxh->dstnet;                            break;
    case 'K': memcpy(srch.xad1,pxh->srcnode,sizeof(ethernet_address));
	      srch.xnod1 = pxh->srcnet;                            break;
    case 'L': memcpy(srch.xad1,pxh->dstnode,sizeof(ethernet_address));
	      srch.xnod1 = pxh->dstnet;
	      memcpy(srch.xad2,pxh->srcnode,sizeof(ethernet_address));
	      srch.xnod2 = pxh->srcnet;                            break;
    case 'M': srch.port  = thd->dst;                               break;
    case 'N': srch.port  = thd->src;                               break;
    case 'O': srch.port  = uhd->dst;                               break;
    case 'P': srch.port  = uhd->src;                               break;
    case 'Q': srch.port  = pxh->dstsock;                           break;
    case 'R': srch.port  = pxh->srcsock;                           break;
    case 'S': if((reply[2]=='0')&&(toupper(reply[3])=='X'))
		   srch.port = swap(htoi(&reply[4],4));
	      else srch.port = swap(atoi(&reply[2]));
	      if(!srch.port)   srch.mode = 0;                      break;
    case 'T': srch.pr_cod = htoi(&reply[2],4);
	      if(!srch.pr_cod) srch.mode = 0;			   break;
    }
  }

int cmprec(void) {
  if(!srch.mode) return(enh->etyp==0);
  check_frame();
  check_protocol();
  switch(srch.mode) {
    case 'A': return(frame_type!=srch.fr_typ);
    case 'B': return((frame_type!=srch.fr_typ)||(protocol_code!=srch.pr_cod));
    case 'C': return((frame_type!=srch.fr_typ)||(protocol_type!=IP)||(srch.pr_sub!=ihd->prot));
    case 'D':
    case 'E': return(  memcmp(srch.ead1,enh->dst,sizeof(ethernet_address))
		  &&   memcmp(srch.ead1,enh->src,sizeof(ethernet_address)) );
    case 'F': return(( memcmp(srch.ead1,enh->dst,sizeof(ethernet_address))
		    || memcmp(srch.ead2,enh->src,sizeof(ethernet_address)) )
		  && ( memcmp(srch.ead1,enh->src,sizeof(ethernet_address))
		    || memcmp(srch.ead2,enh->dst,sizeof(ethernet_address)) ));
    case 'G':
    case 'H': return( (protocol_type!=IP)
		  || ( memcmp(srch.iad1,ihd->dst,sizeof(ip_address))
		    && memcmp(srch.iad1,ihd->src,sizeof(ip_address)) ));
    case 'I': return( (protocol_type!=IP)
		 || (( memcmp(srch.iad1,ihd->dst,sizeof(ip_address))
		    || memcmp(srch.iad2,ihd->src,sizeof(ip_address)) )
		  && ( memcmp(srch.iad1,ihd->src,sizeof(ip_address))
		    || memcmp(srch.iad2,ihd->dst,sizeof(ip_address)) )));
    case 'J':
    case 'K': return( (protocol_type!=IPX)
		  || ( (srch.xnod1!=pxh->dstnet||memcmp(srch.xad1,pxh->dstnode,sizeof(ethernet_address)))
		    && (srch.xnod1!=pxh->srcnet||memcmp(srch.xad1,pxh->srcnode,sizeof(ethernet_address))) ));
    case 'L': return( (protocol_type!=IPX)
		 ||  ( srch.xnod1!=pxh->dstnet||memcmp(srch.xad1,pxh->dstnode,sizeof(ethernet_address))
		    || srch.xnod2!=pxh->srcnet||memcmp(srch.xad2,pxh->srcnode,sizeof(ethernet_address)) )
		  && ( srch.xnod1!=pxh->dstnet||memcmp(srch.xad1,pxh->dstnode,sizeof(ethernet_address))
		    || srch.xnod2!=pxh->srcnet||memcmp(srch.xad2,pxh->srcnode,sizeof(ethernet_address)) ));
    case 'M':
    case 'N': return((protocol_type!=IP)||(ihd->prot!=6)||(srch.port!=thd->dst&&srch.port!=thd->src));
    case 'O':
    case 'P': return((protocol_type!=IP)||(ihd->prot!=17)||(srch.port!=uhd->dst&&srch.port!=uhd->src));
    case 'Q':
    case 'R': return((protocol_type!=IPX)||(srch.port!=pxh->dstsock&&srch.port!=pxh->srcsock));
    case 'S': return(((protocol_type!=IP)||(ihd->prot!=6)||(srch.port!=thd->dst&&srch.port!=thd->src))
		 &&  ((protocol_type!=IP)||(ihd->prot!=17)||(srch.port!=uhd->dst&&srch.port!=uhd->src))
		 &&  ((protocol_type!=IPX)||(srch.port!=pxh->dstsock&&srch.port!=pxh->srcsock)) );
    case 'T': return(protocol_code!=srch.pr_cod);
    case 'U': return(memcmp(broadcast,enh->dst,sizeof(ethernet_address)));
    }
  return(1);
  }

void find_next(word backwards) {
  word oldpos;
  int found;
  found = 0;
  oldpos = rec.num;
  gotoxy(1,23);
  if(!isopen(infil)) return;
  cprintf("Please wait ...\r");
  if(backwards) while(!found&&rec.num) {
    read_record(rec.num-1);
    found = !cmprec();
    }
  else while(!found&&!feof(infil)) {
    next_record();
    found = !cmprec();
    }
  if(found) update++;
  else {
    read_record(oldpos);
    gotoxy(1,23);
    cprintf("%-45s\r","Not found!");
    }
  }

//----- interactive mode ----------------------------------------

char *decode(void) {
  static char ts[80];
  union {
    byte          a[10];
    unsigned long l;
    } td;
  int i,j,dptr;
  td.l = 0L;
  dptr = (autowid>0)?datptr+1:datptr;
  switch (datcmd) {
    case 'b': if(datwid>6) datwid = 6;
	      ts[0] = '\0';
	      for(i=datwid; i>=0; i--) strcat(ts,bin2str(rec.buf[dptr+i]));
	      return(ts);
    case 'B': if(datwid>6) datwid = 6;
	      ts[0] = '\0';
	      for(i=0; i<=datwid; i++) strcat(ts,bin2str(rec.buf[dptr+i]));
	      return(ts);
    case 'd': if(datwid>3) datwid = 3;
	      memcpy(&td.a,&rec.buf[dptr],datwid+1);
	      sprintf(ts,"%lu",td.l);
	      return(ts);
    case 'D': if(datwid>3) datwid = 3;
	      for(i=datwid,j=0; i>-1; i--,j++) td.a[j] = rec.buf[dptr+i];
	      sprintf(ts,"%lu",td.l);
	      return(ts);
    case 'o': if(datwid>3) datwid = 3;
	      memcpy(&td.a,&rec.buf[dptr],datwid+1);
	      sprintf(ts,"%lo",td.l);
	      return(ts);
    case 'O': if(datwid>3) datwid = 3;
	      for(i=datwid,j=0; i>-1; i--,j++) td.a[j] = rec.buf[dptr+i];
	      sprintf(ts,"%lo",td.l);
	      return(ts);
    case 'i':
    case 'I': datwid = 3;
	      return(ipad2str(&rec.buf[dptr]));
    case 'n':
    case 'N': if(autowid) { if(datwid&1) datwid--; }
	      else if(!(datwid&1)&&datwid) datwid--;
	      for(i=j=0; j<78&&i<datwid; j++,i+=2)
		ts[j] = ((rec.buf[dptr+i]-'A')<<4)|(rec.buf[dptr+i+1]-'A');
	      ts[j] = '\0';
	      if((i=ts[j-1])<' ') sprintf(&ts[j-1],"<%02X>",i);
	      return(ts);
    }
  return(" ");
  }

void show_record(void) {
  int i,j,k,l;
  clrscr();
  if(errmsg[0]) {
    textattr(0X70);
    cprintf("%s",errmsg);
    textattr(0X07);
    gotoxy(10,5);
    cprintf("use <F1> to capture new data");
    gotoxy(10,7);
    cprintf(" or <F5> to open an existing file");
    }
  else {
    check_frame();
    check_protocol();
    textattr(0X70);
    cprintf("File: %-12s Record#%-5d Size=%-4d Pos=%-8ld Frametype=Ethernet_%-5s",basnam,rec.num,rec.siz,recpos,ftypes[frame_type]);
    textattr(0X07);
    gotoxy(1,2);
    show_header();
    if(hlptr<0) k = l = -1;
    else {
      if(hlptr>=strlen(hdstr)) hlptr = strlen(hdstr) - 1;
      for(i=k=0; i<hlptr; i++) k += hdhlp[hdstr[i]][0];
      l = k + hdhlp[hdstr[hlptr]][0];
      gotoxy(1,5);
      textattr(15);
      cprintf("%s",&hdhlp[hdstr[hlptr]][1]);
      textattr(7);
      }
    gotoxy(1,6);
    for(i=0; i<hdl; i+=24) {
      cprintf("%04X",i);
      for(j=0; j<24; j++) if((i+j)<hdl) {
	if(((i+j)>=k)&&((i+j)<l)) {
	  textattr(15);
	  cprintf("%s%02X",(j&7)?" ":"  ",rec.buf[i+j]);
	  textattr(7);
	  }
	else cprintf("%s%02X",(j&7)?" ":"  ",rec.buf[i+j]);
	}
      cprintf("\n\r");
      }
    k = ((hdl + 23) / 24) + 7;
    l = rec.siz - ((23 - k) * 16);
    if(datptr<0) datptr = hdl - 1;
    if(datptr>=hdl) {
      if(autowid>0) datwid = rec.buf[datptr];
      else if(autowid<0) for(i=datptr,datwid=0; rec.buf[i]&&i<rec.siz; i++,datwid++);
      gotoxy(1,k-1);
      textattr(15);
      cprintf("%04X",datptr);
      if(datcmd) cprintf("  %c  %s",datcmd,decode());
      textattr(7);
      }
    else datwid = datcmd = autowid = 0;
    dmplim = (l>0)?l:0;
    for(l=k,i=hdl+dmpoff; i<rec.siz&&l<23; i+=16,l++) {
      gotoxy(1,l);
      cprintf("%04X  ",i);
      for(j=0; j<16; j++) if(i+j>=rec.siz) cprintf("  %s",((j&7)==7)?"  ":" ");
			  else {
			    if((i+j>=datptr)&&(i+j<=datptr+datwid)) textattr(15);
			    cprintf("%02X%s",rec.buf[i+j],((j&7)==7)?"  ":" ");
			    textattr(7);
			    }
      for(j=0; j<16; j++) {
	if(i+j>=rec.siz) cprintf(" ");
	else {
	  if((i+j>=datptr)&&(i+j<=datptr+datwid)) textattr(15);
	  cprintf("%c",(rec.buf[i+j]>31)?rec.buf[i+j]:'');
	  textattr(7);
	  }
	}
      }
    gotoxy(1,23);
    if((l>22)&&(dmplim>hdl)) cprintf("< \030 >,< \031 > to scroll data  ");
    if(hdl<rec.siz) cprintf("<CTRL/\033\030\031\032> to move data cursor");
    }
  textattr(0X70);
  gotoxy(1,24);
  if(datptr<(int)hdl) cprintf("%-79s","<Home>first <Pg\030>prev < \033 >,< \032 >help   <F1>capture  <F3>find fwd    <F5>open");
  else cprintf("%-79s","<Home>first <Pg\030>prev  b:bin d:dec o:oct I:IP-addr  1..9 fix size  <SPC> clear");
  gotoxy(1,25);
  if(datptr<(int)hdl) cprintf("%-79s"," <End>last  <Pg\031>next <CTRL/Pg\030\031>fast   <F2>criteria <F4>find bck    <ESC>exit");
  else cprintf("%-79s"," <End>last  <Pg\031>next  B:BIN D:DEC O:OCT N:NB-name  0,# auto size  <TAB> step");
  textattr(0X07);
  gotoxy(1,24);
  update = 0;
  }

//----- batch mode ----------------------------------------------

void batch_mode(void) {
  int i,j;
  if(!isopen(infil)) exit(2);
  fprintf(stderr,"\n\n operating in batch mode ...\r");
  while(!feof(infil)) {
    check_frame();
    check_protocol();
    printf("****** record #%-5d size %-4d offset %-8ld frame type ETHERNET_%s\n",
				 rec.num,rec.siz,recpos,ftypes[frame_type]);
    show_header();
    printf("\n");
    for(i=0; i<hdl; i+=24) {
      printf("%04X",i);
      for(j=0; j<24; j++) if((i+j)<hdl) printf("%s%02X",(j&7)?" ":"  ",rec.buf[i+j]);
      printf("\n");
      }
    printf("\n");
    for(i=hdl; i<rec.siz; i+=16) {
      printf("%04X  ",i);
      for(j=0; j<16; j++) if(i+j>=rec.siz) printf("  %s",((j&7)==7)?"  ":" ");
			  else printf("%02X%s",rec.buf[i+j],((j&7)==7)?"  ":" ");
      for(j=0; j<16; j++) printf("%c",(i+j>=rec.siz)?' ':(rec.buf[i+j]>31)?rec.buf[i+j]:'');
      printf("\n");
      }
    printf("\n");
    next_record();
    }
  fprintf(stderr,"%-50s\n","");
  }

//----- higher level file routines ------------------------------

void open_infile(void) {
  char *p;
  errmsg[0] = '\0';
  basnam = filnam;
  maxnum = poshift = posmask = rec.num = rec.siz = 0;
  recpos = maxpos = 0L;
  memset(rec.buf,0,sizeof(rec.buf));
  for(p=filnam; *p; p++) if((*p==':')||(*p=='\\')) basnam = ++p;
  if((infil=fopen(filnam,"rb"))==NULL)
    sprintf(errmsg,"ERROR: cannot open file: %-50.50s",filnam);
  else {
    fseek(infil,0L,SEEK_END);
    if(ftell(infil)==0L)
    sprintf(errmsg,"ERROR: file is empty: %-50.50s",filnam);
    else {
      fseek(infil,0L,SEEK_SET);
      next_record();
      if(rec.num||(rec.siz<60)||(rec.siz>1508)) {
	sprintf(errmsg,"ERROR: bad file format: %-50.50s",filnam);
	fclose(infil);
	}
      }
    }
  update = 1;
  if(errmsg[0]) {
    fprintf(stderr,"%s\n",errmsg);
    if(strcmp(filnam,wrknam)) update = 0;
    strcpy(filnam,"???");
    basnam = filnam;
    }
  }

void file_menu(void) {
  char *p1, *p2, lbl, ch, *path, name[6];
  char first,last;
  struct ffblk ff_blk;
  int i;
  for(p1=p2=wrknam; *p1; p1++) if((*p1==':')||(*p1=='\\')) p2 = p1 + 1;
  for(p1=p2; *p1; p1++) if(*p1=='.') p2 = p1;
  strcpy(name,"*");
  strcat(name,p2);
  do {
    clrscr();
    textattr(0X70);
    cprintf("%-79s"," Open an existing file or change directory");
    textattr(0X07);
    path = getcwd(NULL,80);
    if(path!=NULL) {
      cprintf("\r\n\n%s",path);
      free(path);
      }
    lbl = 'A';
    i = findfirst("*.*",&ff_blk,FA_DIREC);
    while(!i&&lbl<'Z') {
      if((ff_blk.ff_attrib&FA_DIREC)&&(strcmp(ff_blk.ff_name,"."))) {
	gotoxy((lbl&1)?6:40,((lbl-65)>>1)+5);
	cprintf("%c: %-12s <DIR>\n",lbl++,ff_blk.ff_name);
	}
      i = findnext(&ff_blk);
      }
    first = lbl;
    i = findfirst(name,&ff_blk,0);
    while(!i&&lbl<'Z') {
      gotoxy((lbl&1)?6:40,((lbl-65)>>1)+5);
      cprintf("%c: %s\n",lbl++,ff_blk.ff_name);
      i = findnext(&ff_blk);
      }
    last = lbl - 1;
    cprintf("\n\renter A..%c to select (or <ESC>) please: ",last);
    do {
      i = 0;
      if(kbhit()) i = toupper(getch());
      } while(!i||((i!=27)&&((i<'A')||(i>last))));
    while(kbhit()) getch(); // remove extra characters
    if(i==27) {
      update++;
      return;       // <ESC>
      }
    cprintf("%c\n\r",i);
    ch = i;
    if(ch<first) {
      lbl = '@';
      i = findfirst("*.*",&ff_blk,FA_DIREC);
      while(!i&&lbl<first) {
	if((ff_blk.ff_attrib&FA_DIREC)&&(strcmp(ff_blk.ff_name,"."))) lbl++;
	if(lbl==ch) break;
	i = findnext(&ff_blk);
	}
      chdir(ff_blk.ff_name);
      }
    else {
      lbl = first;
      i = findfirst(name,&ff_blk,0);
      while(!i&&lbl<ch) {
	lbl++;
	i = findnext(&ff_blk);
	}
      }
    } while(ch<first);
  strcpy(filnam,ff_blk.ff_name);
  if(isopen(infil)) fclose(infil);
  open_infile();
  }

//----- capture mode --------------------------------------------

void prepare_capturing(void) {
  int i,j,k,l;
  if(!use_alternate) {
    strcat(cmdlin,wrknam);
    strcat(cmdlin,caparg);
    }
  else {
    if(cmdlin[0]) {
      for(i=j=k=strlen(cmdlin); i; i--) {
	if(cmdlin[i]=='.') j = i;
	if((cmdlin[i]=='/')||(cmdlin[i]==' ')) k = i;
	}
      for(i=0,l=-1; i<k; i++) if((cmdlin[i]==':')||(cmdlin[i]=='\\')) l = i;
      if((l>-1)||(k<1)) cmdlin[0] = 0;
      else {
	strncpy(cmdprg,cmdlin,k);
	if(k<sizeof(cmdprg)) cmdprg[k] = '\0';
	strupr(cmdprg);
	if(j>=k) strcat(cmdprg,".EXE");
	for(i=0; i<k; i++) cmdlin[i] = toupper(cmdlin[i]);
	if(j<k) for(i=j; i<k; i++) cmdlin[i] = ' ';
	for(i=k=strlen(cmdlin); i>1; i--) if((cmdlin[i]=='/')&&(cmdlin[i-1]!=' ')) {
	  for(j=k; j>=i; j--) cmdlin[j+1] = cmdlin[j];
	  cmdlin[i] = ' ';
	  }
	strcat(cmdlin,wrknam);
	strcat(cmdlin," ");
	strcat(cmdlin,cmdarg);
	}
      if(!cmdlin[0]) sprintf(errmsg,"ERROR: malformed /C-argument");
      }
    if(!cmdlin[0]) {
      strcpy(cmdprg,"ETHCAPT.EXE");
      strcpy(cmdlin,"ETHCAPT ");
      strcat(cmdlin,wrknam);
      }
    }
  }

void capture_data(void) {
  char newnam[82];
  char *p, *p1, *p2, *p3;
  int n;
  clrscr();
  textattr(0X70);
  cprintf("%-79s"," Capturing new data ...");
  textattr(0X07);
  cprintf("\n");
  if(searchpath(cmdprg)) {
    if(isopen(infil)) fclose(infil);
    strcpy(filnam,wrknam);
    if((infil=fopen(filnam,"rb"))!=NULL) {
      fclose(infil);
      cprintf("\n\rWorkfile already exists: %s\n\r",filnam);
      cprintf("Enter new name to save it or just <RETURN> to overwrite it\n\r");
      cprintf(">");
      newnam[0] = 80;
      cgets(newnam);
      cprintf("\n\r");
      if(newnam[1]) {
	for(p=p1=wrknam;     *p; p++) if((*p=='\\')||(*p==':')) p1 = p+1;
	for(p=p1,p2=NULL;    *p; p++) if (*p=='.') p2 = p;
	for(p=p1=filnam;     *p; p++) if((*p=='\\')||(*p==':')) p1 = p+1;
	for(p=p3=&newnam[2]; *p; p++) if((*p=='\\')||(*p==':')) p3 = p+1;
	if((p=strchr(p3,'.'))!=NULL) {
	  p3[12] = '\0';
	  p[4]   = '\0';
	  }
	else {
	  p3[8] = '\0';
	  if(p2) strcat(p3,p2);
	  }
	strcpy(p1,p3);
	printf("\nRenaming: %s\n      to: %s\n",wrknam,filnam);
	rename(wrknam,filnam);
	strcpy(filnam,wrknam);
	}
      else printf("\nOverwriting: %s\n",filnam);
      }
    cprintf("\n\r%s\n\n\r",cmdlin);
    n = system(cmdlin);
    }
  else {
    cprintf("\n\rCannot find capturing program: %s\n\r",cmdprg);
    n = 1;
    }
  if(!n) {
    open_infile();
    if(errmsg[0]) n = 1;
    }
  if(n) {
    cprintf("\n\rpress any key ... ");
    do { } while(!kbhit());
    while(kbhit()) getch();
    }
  update++;
  }

//----- help screen ---------------------------------------------

void help_text(void) {
  printf("\n\n\n");
  printf("  ETHSHOW %s%s by Jrgen Hoffmann (2009) j_hoff@hrz1.hrz.tu-darmstadt.de\n\n",version,MEMORY_MODEL);
  printf("  usage: ethshow [ options ] [ filename [ > filename ] ]\n\n");
  printf("  valid options:\n");
  printf("    /C[prg] define alternate capturing program instead of ETHDUMP\n");
  printf("            if [prg] is not given, ETHCAPT is assumed\n");
  printf("    /O<arg> additional arguments for [prg]\n");
  printf("            example: \"/Cethwatch.exe/f /O192.168.5.0/24\"\n");
  printf("    /W<fil> define path and name of workfile for capturing\n");
  printf("            current default: %s\n",wrknam);
  printf("    /I<int> /A<adr> /D<dst> /S<src> /T<typ> /P<off>:<pat>\n");
  printf("    /N  and /Z<n> are just passed through to ETHDUMP\n");
  printf("            and have no effect if /C is also given\n");
  printf("    /H /?   print this help text\n\n");
  printf("    The environment variable ETHSHOWTMP can be used to set a new\n");
  printf("    default workfile (which may still be overridden by /W<fil>)\n\n");
  }

//----- main program --------------------------------------------

void main(int argc, char *argv[]) {
  int  i,ch;
  char *p;

  if((p=getenv("ETHSHOWTMP"))!=NULL) {
    strncpy(wrknam,p,128);
    strcpy(filnam,wrknam);
    }
  for(i = 1; i < argc; i++)
    if(*argv[i]=='-' || *argv[i]=='/') {
      p = argv[i];
      switch(toupper(p[1])) {
	case 'C': use_alternate = 1;
		  if(p[2]) strncpy(cmdlin,&p[2],110);
		  else cmdlin[0] = '\0';     break;
	case 'O': strncpy(cmdarg,&p[2],78);  break;
	case 'W': strncpy(wrknam,&p[2],128); break;
	case 'H':
	case '?': help_text(); exit(1);
	case 'I': case 'A': case 'D': case 'S':
	case 'N': case 'T': case 'P': case 'Z':
		  strcat(caparg," ");
		  if((strlen(caparg)+strlen(p)+strlen(wrknam)+16)<128)
		  strcat(caparg,p);
					     break;
	} /* switch */
      } /* if */
    else strncpy(filnam,argv[i],128);
  prepare_capturing();
  open_infile();
  srch.mode = 0;
  ch = 0;
  if(NULL==getcwd(pathbuf,sizeof(pathbuf))) pathbuf[0] = '\0';
  if(!(stdout->flags&_F_TERM)) batch_mode();
//----- main loop (begin) ---------------------------------------
  else do {
    if(update) show_record();
    if(kbhit()) {
      ch = getch();
      if(!ch) {
	ch = getch();
	switch (ch) {
	  case 0X3B: capture_data();  break;      // [F1]
	  case 0X3C: search_dialog(); break;      // [F2]
	  case 0X3D: find_next(0);    break;      // [F3]
	  case 0X3E: find_next(1);    break;      // [F4]
	  case 0X3F: file_menu();     break;      // [F5]
	  case 0X47: read_record(0);
		     update++; break;             // cursor home
	  case 0X48: if(dmpoff>15) {dmpoff -=16;
		     update++;}break;             // cursor up
	  case 0X49: if(rec.num) read_record(rec.num-1);
		     update++; break;             // page up
	  case 0X4B: if(hlptr>-1) { hlptr--;
		     update++; } break;           // cursor left
	  case 0X4D: hlptr++; update++; break;    // cursor right
	  case 0X4F: fseek(infil,maxpos,SEEK_SET);
		     while(!feof(infil)) next_record();
		     update++; break;             // end
	  case 0X50: if(hdl+dmpoff<dmplim) {dmpoff += 16;
		     update++;}break;             // cursor down
	  case 0X51: read_record(rec.num+1);
		     update++; break;             // page down
	  case 0X73: if(datptr>=hdl) {
		     if(datptr>hdl+dmpoff) datptr--;
		     else datptr = hdl - 1;
		     update++;}break;             // CTRL/cursor left
	  case 0X74: if(datptr<rec.siz-1) {
		     if(datptr<hdl+dmpoff) datptr= hdl+dmpoff;
		     else datptr++;
		     update++;}break;             // CTRL/cursor right
	  case 0X76: read_record(rec.num+(maxnum>>3)+1);
		     update++; break;             // CTRL/page down
	  case 0X84: if(rec.num<(maxnum>>3)) read_record(0);
		     else read_record(rec.num-(maxnum>>3)-1);
		     update++; break;             // CTRL/page up
	  case 0X8D: if(datptr>hdl) {
		     if(datptr>hdl+dmpoff+15) datptr -= 16;
		     else datptr = hdl - 1;
		     update++;}break;             // CTRL/cursor up
	  case 0X91: if(datptr<rec.siz-16) {
		     if(datptr>=hdl+dmpoff) datptr += 16;
		     else datptr=hdl+dmpoff;
		     update++;}break;             // CTRL/cursor down
	  }
	}
      else {
	if(ch=='#') {
	  autowid = 1;
	  update++;
	  }
	else if(ch=='0') {
	  autowid = -1;
	  update++;
	  }
	else if(ch==9) {
	  if(datptr+datwid<rec.siz-1) {
	    datptr += (datwid+1);
	    update++;
	    }
	  }
	else if(isdigit(ch)) {
	  datwid = (ch & 0X0F) - 1;
	  autowid = 0;
	  update++;
	  }
	else if(strchr(" BDINO",toupper(ch))!=NULL) {
	  datcmd = (ch!=' ')?ch:0;
	  update++;
	  }
	}
      }
    } while(ch != 27);
//----- main loop (end) -----------------------------------------
  if(pathbuf[0]) chdir(pathbuf);
  if(isopen(infil)) fclose(infil);
  if(stdout->flags&_F_TERM) {
    gotoxy(1,23);
    cprintf("%-79s","");
    gotoxy(1,24);
    cprintf("%-79s","");
    gotoxy(1,25);
    cprintf("%-79s","");
    gotoxy(1,24);
    }
  }



