;    LSPPP - DOS PPP Packet Driver
;    Copyright (C) 1997-2003  David Lindauer
;
;    This program is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    This program is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with this program; if not, write to the Free Software
;    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;
;    (for GNU General public license see file COPYING)
;
;    you may contact the author at:  mailto::camille@bluegrass.net
; 
;    or by snail mail at:
;
;    David Lindauer
;    850 Washburn Ave.  Apt #99
;    Louisville, KY 40222
;
include ppp.asi
;
; note that I never send term-request, but instead simply drop the carrier
; mean, but effective...
;
; also I'm not sure when configuration options take effect
;
; finally the configuration stuff is hard-coded, if you add configuration
; options you will have to add them in several places
;
;
; IPCP options tht we are interested in.  Others are rejected
; only the AUTH is negotiated for
;
IPCP_ADDRESSES = 1
IPCP_COMPRESSION = 2
IPCP_ADDRESS_REQ = 3
IPCP_DNS_1 = 129
IPCP_DNS_2 = 131
;
; flags for which options we can send in a CONFREQ packet
;
IF_COMPRESSION = 1
IF_COMPRESSION_OLD = 2
IF_ADDRESS_REQ = 4
IF_DNS_1 = 8
IF_DNS_2 = 16

CGROUP group TSR,CONFIG
	assume cs:cgroup,ds:cgroup
	public IPCP_init, ipcpdown
	public	IPCP_struc, ipaddr, hisipaddr, dns1, dns2
	extrn sm_init : PROC, sm_handler : PROC
	extrn tlu : PROC, tld : PROC
	extrn confbuf : byte, xmitvjcomp : byte, xmitvjcompstates : byte
	extrn xmitvjcompid : byte, vjinit : proc
	extrn GetNameservAddress : proc
	extrn numservers : byte , baseservers : byte 
        extrn rcvvjcompstates : byte
TSR segment word public 'CODE'
defconf	LABEL byte
ifndef NOVJ
		db	IPCP_COMPRESSION,6,0,IP_VJ_COMPRESSED_PROTOCOL,MAX_VJ_STATES-1,1
		db	IPCP_COMPRESSION,4,0,IP_VJ_COMPRESSED_PROTOCOL ; old version
endif
ipconf		db	IPCP_ADDRESS_REQ,6
ipaddr		db	0,0,0,0
		db 	IPCP_DNS_1,6
dns1		dd	0
		db	IPCP_DNS_2,6
dns2		dd	0
IPCP_struc      statemachine    <IF_COMPRESSION + IF_ADDRESS_REQ + IF_DNS_1 + IF_DNS_2,0,0,0,0,DEFAULT_COUNT,0,DEFAULT_TIME*18+DEFAULT_TIME/5,0,IPCP_PROTOCOL,ipcpreneg,ipcpreq,ipcpaccept,ipcpconfack,ipcpverify,ipcpnoreject,ipcpdown,ipcpup>
					; to send in conf reqs
hisipaddr	dw	0,0
;
; 
ipcpnoreject PROC
	cmp	al,IPCP_ADDRESS_REQ
	jz	nrj
    	cmp	al,IPCP_COMPRESSION
nrj:
	ret
ipcpnoreject ENDP
;
; nack or reject comes here;
;
ipcpreneg PROC
	mov	al,byte ptr [si]
	cmp	al,IPCP_COMPRESSION	; compression?
	jnz	scrnpc
	and	[bx].sm_flags,NOT IF_COMPRESSION	; yep, don't send again

scrnpc:
	cmp	al,IPCP_ADDRESS_REQ		; address req
	jnz	scrndns1
	or	dl,dl
	jz 	newip	                        ; rejected?
	and	[bx].sm_flags,NOT IF_ADDRESS_REQ	; yep, don't send it again
	ret
newip:
	mov	ax,[si+2]			; else pick up the address they gave
	mov	word ptr [ipaddr],ax
	mov	ax,[si+4]
	mov	word ptr [ipaddr+2],ax
	ret
scrndns1:
	cmp	al,IPCP_DNS_1			; did they nak primary DNS
	jnz	scrndns2
	or	dl,dl				; reject?
	jz	dns1nak
	and	[bx].sm_flags, NOT IF_DNS_1	; yes, don't send any more
	ret
dns1nak:
	mov	ax,[si+2]			; else load it
	mov	word ptr [dns1],ax
	mov	ax,[si+4]
	mov	word ptr [dns1+2],ax
	ret
scrndns2:
	cmp	al,IPCP_DNS_2                   ; did they nak secondary dns
	jnz	scrnx
	or	dl,dl				; reject?
	jz	dns2nak
	and	[bx].sm_flags, NOT IF_DNS_2	; yes, don't send any more
	ret
dns2nak:
	mov	ax,[si+2]			; else load it
	mov	word ptr [dns2],ax
	mov	ax,[si+4]
	mov	word ptr [dns2+2],ax
scrnx:
	ret
	
ipcpreneg ENDP
;
; we send our current confreq or timeout has occurred so resend
;
ipcpreq	PROC
	sub	dx,dx
	mov	si,offset cgroup:defconf	; get def configuration
ifndef NOVJ
	test	[bx].sm_flags,IF_COMPRESSION	; see if doing compression
	jz	noprot
	movsw				; yes do it
	movsw
	movsw
	sub	si,6
	add	dx,6
noprot:
	add	si,6
	test	[bx].sm_flags,IF_COMPRESSION_OLD	; see if doing compression
	jz	noprot2
	movsw				; yes do it
	movsw
	sub	si,4
	add	dx,4
noprot2:
	add	si,4
endif
	test	[bx].sm_flags,IF_ADDRESS_REQ	; see if doing adrreq
	jz	noadr			;
	movsw				; yes do it
	movsw
	movsw
	add	dx,6
	sub	si,6
noadr:
	add	si,6
	test	[bx].sm_flags, IF_DNS_1 ; see if doing first DNS
	jz	nodns1
	movsw
	movsw
	movsw
	add	dx,6
	sub	si,6
nodns1:
	add	si,6
	test	[bx].sm_flags, IF_DNS_2 ; see if doing first DNS
	jz	nodns2
	movsw
	movsw
	movsw
	add	dx,6
nodns2:
	mov	ax,dx
	ret
ipcpreq	ENDP
;
; they like ours
;
ipcpconfack PROC
;	nothing to do.  If they liked our compression setup they can
;	send what they want...
ifndef NOVJ
        cmp     byte ptr [si],IPCP_COMPRESSION
        jnz     ica_x
        mov     al,16
        cmp     byte ptr [si+1],6
        jnz     ica_s
        mov     al,[si+4]
        inc     al
ica_s:
        mov     [rcvvjcompstates],al
ica_x:
endif
	ret
ipcpconfack ENDP
;
; we like theirs
;
ipcpaccept PROC
ifndef NOVJ
	cmp	BYTE PTR [si],IPCP_COMPRESSION
	jnz	ocac
	inc	[xmitvjcomp]
	mov	[xmitvjcompstates],16
	mov	[xmitvjcompid],0
	cmp	byte ptr [si+1],5
	jc	ocacg
	mov	al,[si+4]
	inc	al
	mov	[xmitvjcompstates],al
	cmp	byte ptr [si+1],6
	jc	ocacg
	mov	al,[si+5]
	mov	[xmitvjcompid],al
ocacg:
endif
ocac:
	cmp	BYTE PTR [si],IPCP_ADDRESS_REQ
	jnz	oca
	mov	ax,[si + 2]
	mov	[hisipaddr],ax
	mov	ax,[si + 4]
	mov	[hisipaddr+2],ax
oca:
;	mov	word ptr [ipaddr],0d4c7h
;	mov	word ptr [ipaddr+2],09c5eh
;	mov	word ptr [hisipaddr],0d4c7h
;	mov	word ptr [hisipaddr+2],0485eh

	ret
ipcpaccept ENDP	
;
; Check if a particular conf entry is valid or not,
; note we do NOT receive address req
;
ipcpverify PROC
ifndef NOVJ
	lahf
	cmp	byte ptr [si],IPCP_COMPRESSION
	jnz	chkadreq
	cmp	word ptr [si+2],2d00h ; COMP, did they specify VJ
	jz	vc2
	mov	word ptr [si+2],2d00h ; no, renogotiate for VJ
	stc
	ret
vc2:
	cmp	byte ptr [si+1],5		; now see if they set states
	jc	vce			; out if defaulting
	cmp	byte ptr [si+4],MAX_VJ_STATES-1	; else check if ok
	jbe	vce			; yes, out
	mov	byte ptr [si+4],MAX_VJ_STATES-1	; else renegotiate for our max
	stc
	ret
	
endif
chkadreq:
	cmp	byte ptr [si],IPCP_ADDRESS_REQ
	jz	vce
nofix:
	mov	[confbuf],LCP_CONFREJ
	stc
	ret
vce:
	clc
	ret
ipcpverify ENDP

ipcpdown PROC
;	call	tld
	ret
ipcpdown ENDP
ipcpup	PROC
;	call	tlu
	push	bx
	call	vjinit
	pop	bx
	test	[bx].sm_flags,IF_DNS_1
	jz	ian1
	call	GetNameServAddress
	mov	ax,word ptr [dns1]
	stosw
	mov	ax,word ptr [dns1+2]
	stosw
ian1:
	test	[bx].sm_flags,IF_DNS_2
	jz	ian2
	call	GetNameServAddress
	mov	ax,word ptr [dns2]
	stosw
	mov	ax,word ptr [dns2+2]
	stosw
ian2:
	ret
ipcpup	ENDP
IPCP_init PROC
	mov	al,[baseservers]
	mov	[numservers],al
	mov	bx,offset cgroup:IPCP_struc
	mov	[bx].sm_flags,IF_COMPRESSION + IF_ADDRESS_REQ + IF_DNS_1 + IF_DNS_2
	jmp	sm_init
IPCP_init ENDP
TSR	ENDS
CONFIG	segment word public 'CODE'
CONFIG	ENDS
	end