#ifndef cntfuncs_h
#define cntfuncs_h

#include <stdio.h>
#include "mpxplay.h"
#include "control.h"

#ifdef __cplusplus
extern "C" {
#endif

#define MPXPLAY_CONTROL_CONFIGFILELOADFLAG_SEARCHPARTS    (1 << 0) // search [partnames] (ie:[keyboard],[serialport]) (mpxplay.ini)
#define MPXPLAY_CONTROL_CONFIGFILELOADFLAG_ENDCOMMENTS    (1 << 1) // search for comments at the end of lines (mpxplay.ini only)

extern void mpxplay_control_initvar(int,char *argv[],struct mainvars *);
extern void mpxplay_control_set_default_config(void);
extern void mpxplay_control_getcommandlineopts(void);
extern void mpxplay_control_checkvar(struct mainvars *);
extern void mpxplay_control_start_progexectime(void);
extern void mpxplay_control_extrafiletypes_slice(void);
extern int  mpxplay_control_get_ini_path(char *strbuf);
extern FILE *mpxplay_control_configfile_open(char *filename, const char *mode_pri, const char *mode_sec, unsigned int *ctrl_cfgfile_flags);
extern int  mpxplay_control_configfile_load(FILE *filehand, char **memfield, mpxini_line_t *cfg_lines, unsigned int max_linenum, unsigned int load_flags);
extern void mpxplay_control_configfile_parts_loadini(void);
extern void mpxplay_control_configfile_parts_saveini(void);
extern void mpxplay_control_configfile_parts_init(void);
extern void mpxplay_control_configfile_parts_close(void);
extern void mpxplay_control_configfile_close(void);

extern void mpxplay_control_keyboard_loadini(mpxini_line_t *,struct mpxini_part_t *);
extern void mpxplay_control_keyboard_init(void);
extern void mpxplay_control_keyboard_set_topfunc(void *newtopfunc);
extern void *mpxplay_control_keyboard_get_topfunc(void);
extern mpxp_bool_t mpxplay_control_keyboard_functions(unsigned int extkey,struct mainvars *mvp);
extern mpxp_bool_t mpxplay_keyboard_is_dialog_key(unsigned int keycode);
extern mpxp_bool_t mpxplay_keyboard_is_editor_key(unsigned int keycode);
extern void mpxplay_keyboard_execute_exit(struct mainvars *mvp);
extern void check_dosshellstart(void);
extern void mpxplay_control_keyboard_songnum_reset(void);
extern unsigned int mpxplay_control_keyboard_id3search_initialized(void);

extern void mpxplay_control_keygroup_loadini(mpxini_line_t *,struct mpxini_part_t *);
extern int mpxplay_control_keygroup_getgroup(unsigned int extkey,struct mainvars *);
extern int mpxplay_control_keygroup_getnextfunc(void);

extern void mpxplay_control_fastlist_loadini(mpxini_line_t *,struct mpxini_part_t *);
extern unsigned int mpxplay_control_fastlist_enabled(void);
extern void mpxplay_control_fastlist_searchfilename(struct playlist_side_info *psi,char *filename);
extern unsigned int mpxplay_control_fastlist_keycheck(unsigned int extkey,struct mainvars *);
extern unsigned int mpxplay_control_fastlist_step(struct mainvars *mvp,int direction);

extern void mpxplay_control_serial_loadini(mpxini_line_t *,struct mpxini_part_t *);
extern void mpxplay_control_serial_init(void);
extern void mpxplay_control_serial_close(void);

extern void mpxplay_control_startup_loadlastlist(void);
extern int  mpxplay_control_startup_getstartpos_delayed(struct playlist_side_info *psi, struct playlist_entry_info *pei);
extern void mpxplay_control_startup_getstartpos(struct mainvars *mvp);
extern void mpxplay_control_startup_save_mpxptabsini(void);

#if defined(MPXPLAY_GUI_QT)
extern void mpxplay_dispqt_mouse_loadini(mpxini_line_t *,struct mpxini_part_t *);
extern void mpxplay_dispqt_mouse_init(void);
extern void mpxplay_dispqt_mouse_close(void);
#elif defined(MPXPLAY_GUI_CONSOLE)
extern void mpxplay_control_mouse_loadini(mpxini_line_t *,struct mpxini_part_t *);
extern void mpxplay_control_mouse_winconsole_getevent(void);
extern void mpxplay_control_mouse_init(void);
extern void mpxplay_control_mouse_close(void);
extern void mpxplay_control_mouse_getpos(unsigned int *hmousex,unsigned int *hmousey);
 #ifdef __DOS__
  extern void mpxplay_control_mouse_setrange(unsigned int hx,unsigned int hy);
 #else
  #define mpxplay_control_mouse_setrange(hx,hy)
 #endif
#endif

extern void mpxplay_control_joy_loadini(mpxini_line_t *,struct mpxini_part_t *);
extern void mpxplay_control_joy_init(void);

#ifdef __cplusplus
}
#endif

#endif
