//**************************************************************************
//*                     This file is part of the                           *
//*                 Mpxplay/MMC - multimedia player.                       *
//*                  The source code of Mpxplay is                         *
//*        (C) copyright 1998-2020 by PDSoft (Attila Padar)                *
//*                http://mpxplay.sourceforge.net                          *
//*                  email: mpxplay@freemail.hu                            *
//**************************************************************************
//*  This program is distributed in the hope that it will be useful,       *
//*  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
//*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                  *
//*  Please contact with the author (with me) if you want to use           *
//*  or modify this source.                                                *
//**************************************************************************
//function: FFMPEG library handling

#ifndef FFMPGDEC_H
#define FFMPGDEC_H

//#define MPXPLAY_USE_DEBUGF 1
#define MPXPLAY_DEBUG_ERROR stderr
#define MPXPLAY_DEBUG_WARNING stderr
#ifndef MPXPLAY_DEBUG_OUTPUT
#define MPXPLAY_DEBUG_OUTPUT stdout
#endif
#define MPXPLAY_DEBUG_PLAY   NULL // stdout
#define MPXPLAY_DEBUG_OPENCLOSE  NULL // stdout
#define MPXPLAY_DEBUG_OPENCLSDTL NULL // stdout
#define MPXPLAY_DEBUG_HWDEC stdout
#define MPXPLAY_DEBUG_HEADER  NULL // stdout
#define MPXPLAY_DEBUG_STDUR NULL // stdout
#define MPXPLAY_DEBUG_DEMUX NULL // stdout
#define MPXPLAY_DEBUG_ADECODE NULL // stdout
#define MPXPLAY_DEBUG_AVRESYNC NULL // stdout
#define MPXPLAY_DEBUG_SILENTB NULL // stdout
#define MPXPLAY_DEBUG_QUEUECLEAR NULL // stdout
#define MPXPLAY_DEBUG_QUEUEGET NULL // stdout
#define MPXPLAY_DEBUG_QUEUEGET_AVFRAME NULL // stdout
#define MPXPLAY_DEBUG_QUEUEPUT NULL // stdout
#define MPXPLAY_DEBUG_TIMESTAMP NULL // stdout
#define MPXPLAY_DEBUG_STRMPRIO NULL // stdout
#define MPXPLAY_DEBUG_STRMLIST NULL // stdout
#define MPXPLAY_DEBUG_PRGCHG NULL // stdout
#define MPXPLAY_DEBUG_STRMCHG NULL //stdout
#define MPXPLAY_DEBUG_SEEK NULL // stdout
#define MPXPLAY_DEBUG_CALLBACK NULL // stdout
#define MPXPLAY_DEBUG_TEMP NULL // stdout
#define MPXPLAY_DEBUG_DEMUXSEEKP NULL // stdout

#include "in_file.h"

#ifdef MPXPLAY_LINK_INFILE_FF_MPEG

#define __STDC_CONSTANT_MACROS

#include <libavcodec/avcodec.h>
#include <libavformat/avformat.h>
#include <libavutil/channel_layout.h>
#include <libavutil/pixfmt.h>

#define MPXPLAY_USE_FFMPEG_V7X      (LIBAVCODEC_VERSION_MAJOR > 60)

#ifdef MPXPLAY_USE_DEBUGF
 #define INFFMPG_DEBUG_HEADER 1
#endif

#ifdef MPXPLAY_GUI_QT
#define INFFMP_USE_VIDEO_SYNC     1 // start program with video sync (decode audio to this)
#endif
#define INFFMP_SUPPORT_DVB_AUDIO  1 //
//#define INFFMP_USE_DEMUXER_AUINIT 1 // FIXME: probably this solution is not thread safe, but required in some cases (flac + mjpeg)
#define INFFMPG_USE_MPXPLAY_IOCTX 1 // use Mpxplay's own low level file handling (dvb/ftp/http/file)
// these options shall be used together
#define INFFMP_USE_DEMUXER_THREAD 1 // TODO: frp buffer is not thread safe (pop and video freeze at start)
#define INFFMP_USE_DEMUXER_SEEK   1 // TODO: test
#define INFFMP_USE_DEMUXER_BUFILL 1

//#define INFFMP_USE_DEMUXER_MUTEX  1 // if demux thread and seek are separated (DEMUXER_THREAD is enabled and DEMUXER_SEEK is disabled)
//#define INFFMPG_USE_VIDEOPTS_CORRECTON 1 // for testing only (use avframe->pts instead)

#define INFFMPG_IOCTX_SIZE_MIN 4096
#define INFFMPG_IOCTX_SIZE_MAX 32768
#define INFFMPG_INITIAL_PACKETBUF_SIZE 65536 // TODO: this is good up to 13mbit video at stream length detect
#define INFFMPG_MAX_OUTPUT_SAMPLENUM  131072 // TODO: WMA (32k) & APE (80k) needs such large buffer
#define INFFMPG_MUTEX_TIMEOUT 5000
#define INFFMPG_MUTEX_QUEUEGET_TIMEOUT 10
#define INFFMPG_MUTEXTIME_NOLOCK  0x7eeeeeee
#define INFFMPG_QUEUE_PACKETNUM_MIN  3   // for both audio and video packets
#define INFFMPG_QUEUE_PACKETNUM_FILL_MIN  16
#define INFFMPG_QUEUE_PACKETNUM_FILL_STEP  8
#define INFFMPG_QUEUE_PACKETNUM_FILL_MAX  64
#define INFFMPG_QUEUE_PACKETNUM_MAX 1024  // to limit number of packets

#define INFFMPG_STREAM_INDEX_VALID    0  // >= 0 is a valid stream index
#define INFFMPG_STREAM_INDEX_DISABLE -1  // stream is disabled
#define INFFMPG_STREAM_INDEX_SEARCH  -2  // wait/search/retry for a valid stream
#define INFFMPG_INVALID_STREAM_INDEX -3  //
#define INFFMPG_STREAM_INDEX_LOST    -4  // current stream has lost

#define INFFMPG_STREAM_INDEX_EXTERNALFILE_BEGIN   65536 // stream belongs to a separated (audio, subtitle) file (not an internal stream)
#define INFFMPG_STREAM_INDEX_EXTERNALFILE_NB_MAX  64    // max number of (audio or subtitle) files in the list

#define INFFMPG_INVALID_PTS -1LL
#define INFFMPG_TIMESTAMP_SHIFT  (AV_TIME_BASE) // this must be larger than audio_delay in in_ffmpgdec_decode_audio
#ifdef INFFMPG_USE_VIDEOPTS_CORRECTON
 #define INFFMPG_TIMESTAMP_MAX_AVDIFFERENCE (AV_TIME_BASE / 2)  // max delay between video frames and audio/video frames
#endif // INFFMPG_USE_VIDEOPTS_CORRECTON
#define INFFMPG_TIMESTAMP_LIVE_MAX_AVDIFFERENCE (30 * AV_TIME_BASE) // means out of a/v sync at live streams (play audio unconditionally)
#define INFFMPG_MAX_FRAME_MISMACTHES 25 // * nb_programs
#define INFFMPG_MAX_STREAMS 255
#define INFFMPG_PTS_CHECK_NUM_MAX 12
#define INFFMPG_STILL_PICTURE_FRAME_MAX 3  // progressive jpeg may contain multiply frames
#define INFFMPG_SEEKREQUEST_INVALID_POS -1

#define INFFMPG_FLAG_AUTODETECT       (1 << 0)  // autodetect fileformat
#define INFFMPG_FLAG_LOADHEADONLY     (1 << 1)  // don't open resources for play (eg. video output)
#define INFFMPG_FLAG_IS_STREAM        (1 << 2)  // stream (MPG,TS)
#define INFFMPG_FLAG_IS_SEEKABLE      (1 << 3)  // not live stream
#define INFFMPG_FLAG_IS_LIVESTREAM    (1 << 4)  // live stream
#define INFFMPG_FLAG_IS_ASYNCREAD     (1 << 5)  // async read (read can underrun temporarily)
#define INFFMPG_FLAG_STREAM_PARSING   (1 << 6)  // not live stream
#define INFFMPG_FLAG_INITIAL_SEEK     (1 << 7)  // don't seek to bof and don't clear buffs at first seek
#define INFFMPG_FLAG_SEEK_CLEAR       (1 << 8)  // clear ffctx bufs after seeking
#define INFFMPG_FLAG_INDEPENDENTSTREAMSYNC (1<<9)// do not synchronize A/V streams, every streams use it's own timestamp informations (mixing live stream(s))
#define INFFMPG_FLAG_PLANARAUDIO      (1 <<10)  // audio channels are separated (not interlaced)
#define INFFMPG_FLAG_STILLPICTURE     (1 <<11)  // jpg, bmp, etc.
#define INFFMPG_FLAG_NOMETADATASEND   (1 <<12)  // forbidd sending of metadata to upper layer (eg. DVB live stream with proggram_id -> driver sends the metadata to the app)
#define INFFMPG_FLAG_NOPRGIDCHGSEND   (1 <<13)  // forbidd sending of program_id change to upper layer (eg. DVB live stream with proggram_id -> driver sends the metadata to the app)
#define INFFMPG_FLAG_PROGIDCHGSEND    (1 <<14)  // send program_id change to upper layer (if it's not blocked by FLAG_NOPRGIDCHGSEND)
//#define INFFMPG_FLAG_NONREWINDPRGCHG  (1 <<15)  // perform program change without buffer rewind (videowall based change)
#define INFFMPG_FLAG_CALLBACKVIDEOCFG (1 <<16)  // we've initialized a callback function for video surface (called back from Qt)
#define INFFMPG_FLAG_DEMUX_THREAD     (1 <<17)  // at video files
#define INFFMPG_FLAG_DEMUX_BUFREWIND  (1 <<18)  // rewind buffer at program change
#define INFFMPG_FLAG_DEMUX_TERMINATE  (1 <<19)  //
#define INFFMPG_FLAG_TEXTTYPE_BITPOS  (24)
#define INFFMPG_FLAG_TEXTTYPE_MASK    (0x03) //MPXPLAY_TEXTCONV_TYPE_CHAR (0),  MPXPLAY_TEXTCONV_TYPE_UTF8 (1), MPXPLAY_TEXTCONV_TYPE_UTF16LE (2), MPXPLAY_TEXTCONV_TYPE_UTF16BE (3)

#define INFFMPG_FLAGS_DIRECTCOPY_TO_PACKETTYPE ((1 << INFFMPG_FLAG_TEXTTYPE_BITPOS) | (1 << (INFFMPG_FLAG_TEXTTYPE_BITPOS + 1))) // ffmpeg_external_files_info_s->control_flags to packet_flags

#ifndef AVSEEK_FLAG_PAUSE
#define AVSEEK_FLAG_PAUSE    256
#endif

#define INFFMPG_STREAMFLAG_CLEARBUF_DEMUX  (1 << 0) // stream change or seek postprocess, flag for demultiplexer
#define INFFMPG_STREAMFLAG_SEEK            (1 << 1) // seek flag for demultiplexer (clearbuf flag pass to decoder)
#define INFFMPG_STREAMFLAG_AVSYNC          (1 << 2) // a/v sync by video
#define INFFMPG_STREAMFLAG_AVRESYNC        (1 << 3) // a/v resync by video if video packet queue is full (play video with silent audio (stop audio decoding))

#define INFFMPG_ERROR_STREAM_NOTPARSED        (-1000)
#define INFFMPG_ERROR_STREAM_LANGCODE_MISSING (-1001)  // stream has no language code (for inffmpg_stream_language_cmp)

#define INFFMPG_LANGCODE_ISO6391_LEN  2 // ISO 639-1 language code len
#define INFFMPG_LANGCODE_ISO6392_LEN  3 // ISO 639-2 language code len

#define INFFMPG_EPGPRGCTRLFLAG_ENCRYPTED_PRG   (1 << 0)  // SDT: free_CA_mode is enabled (aka encrypted program)
#define INFFMPG_EPGPRGCTRLFLAG_NOTRUNNING_PRG  (1 << 1)  // SDT: running_status is not "start_soon" (2), "paused" (3) or "running" (4) (aka not valid program)
#define INFFMPG_EPGPRGCTRLFLAG_PROGNAME_SENT   (1 << 16)
#define INFFMPG_EPGPRGCTRLFLAG_CHANID_SENT     (1 << 17)

typedef int (ffmpeg_read_packet_t)(void *, uint8_t *, int);

//-----------------------------------------------------------------------------------------------------------------------------------------------
#define INFFMPG_EPG_TABLE_ID_NUM  256                            // number of table IDs

typedef struct ffmpg_epg_section_data_s{
	struct mpxplay_bitstreambuf_s *section_data_buffer;          // section data collector buffer
	int last_continuity_counter;                                 // continuity counter of the section (by section ID)
    unsigned int section_started;                                // section data collection has started
    mpxp_uint32_t last_crc_value;
	mpxp_uint8_t last_version_number;
}ffmpg_epg_section_data_s;

typedef struct ffmpg_epg_mpegts_data_s
{
	struct mpxplay_bitstreambuf_s *stream_buffer;                // data buffer for the native MPGE-TS data (multiply frames are received in one block from FFMPFILE.C)
	unsigned int mpegts_frame_size;                              // detected MPEG-TS frame size
}ffmpg_epg_mpegts_data_s;

typedef struct ffmpg_epg_info_s{
	unsigned int nb_program_datas;                               // number of program datas in the chain
	struct mpxplay_dvb_epg_program_data_s *epg_program_data_chain;     // first element of program datas chain
	long (*control_cb)(void *ccb_data,unsigned long funcnum,void *argp1,void *argp2);
	void *ccb_data;
	void *ffmpi;
	mpxp_uint64_t carrier_localized_datetime;                    // carrier date and time converted to local time 0xYYYYMMDD00HHMMSS format
	struct ffmpg_epg_mpegts_data_s  mpegts_data;                 // primary data for the MPEG-TS stream
	struct ffmpg_epg_section_data_s section_nit_data;            // section data (nit)
	struct ffmpg_epg_section_data_s section_sdt_data;            // section data (std)
	struct ffmpg_epg_section_data_s section_eit_data;            // section data (eit)
	struct ffmpg_epg_section_data_s section_tdt_data;            // section data (tdt,tot)
}ffmpg_epg_info_s;
//-----------------------------------------------------------------------------------------------------------------------------------------------

typedef struct ffmpeg_external_filelist_elem_s{
 unsigned int stream_index;                          // index begins at INFFMPG_STREAM_INDEX_EXTERNALFILE
 struct ffmpeg_external_filelist_elem_s *next_external_file;  // next external file elem in the chain
 enum AVCodecID codec_id;                            // stream informations
 int  bitrate, channels, samplerate;                 //
 char format_name[8];                                // file extension (like SRT,SUB or MP3)
 char language_code[4];                              // language code (like HUN or ENG)
 char language_name[64];                             // language (long) name
 char external_filename[MAX_PATHNAMELEN];            // filename with full path
}ffmpeg_external_filelist_elem_s;

typedef struct ffmpeg_external_files_info_s{
 struct ffmpeg_external_filelist_elem_s *external_files_chain;
 int nb_external_files;
 struct ffmpeg_external_filelist_elem_s *external_file_selected;
 struct mpxplay_filehand_buffered_func_s *fbfs;
 void *fbds;
 AVIOContext *ioctx;
 unsigned char *iobuffer;
 AVFormatContext *external_file_avctx;
 unsigned int streamtype_index;
 unsigned int control_flags;                         // INFFMPG_FLAG_
 mpxp_int64_t avclocktime_us;                        // reference clock time for independent stream sync
 mpxp_int64_t avtimestamp_us;                        // initial avtimestamp for this stream
 int64_t last_seek_dts;                              // first read dts after seek, seekpreview: skip duplicated seeks, base file:better seek positioning (feedback)
 struct ffmpg_epg_info_s epg_infos;
}ffmpeg_external_files_info_s;

typedef struct ffmpeg_external_outfile_infos_s{
 AVFormatContext *output_file_avctx;                               // FFmpeg output file context
 mpxp_bool_t recording_initiated;                                  // begin of recording flag (open file)
 mpxp_bool_t error;                                                // error at initialization (don't write trailer)
 mpxp_int64_t packet_counter;                                      // packet counter for error-reopen
 mpxp_bool_t  reference_first_flag;                                // reference dts init flag
 mpxp_int32_t reference_stream_idx;                                // reference dts stream index (audio, video, subtitle)
 int64_t reference_dts;                                            // reference dts (zero/start point for all dts)
 mpxp_int32_t last_framewrite_time_sec;                            // previous time in seconds during frame write (for display status)
 int selected_stream_nums[MPXPLAY_STREAMTYPEINDEX_PLAYNUM];        // initial stream numbers (from selected_stream_number[]);
 int selected_ff_stream_indexes[MPXPLAY_STREAMTYPEINDEX_PLAYNUM];  // initial FFmpeg stream indexes (from selected_ff_stream_index[])
 AVStream *out_streams[MPXPLAY_STREAMTYPEINDEX_PLAYNUM];           // allocated output stream infos
 AVRational input_time_base[MPXPLAY_STREAMTYPEINDEX_PLAYNUM];      // input AVStream timebase
 int64_t dts_last[MPXPLAY_STREAMTYPEINDEX_PLAYNUM];                // save last dts for continuity check
 int64_t pts_last[MPXPLAY_STREAMTYPEINDEX_PLAYNUM];                // save last pts for continuity fill
 int duration_last[MPXPLAY_STREAMTYPEINDEX_PLAYNUM];               // save last pkt duration for continuity fill (last_dts + last_duration)
 AVPacket *input_packet_collector[MPXPLAY_STREAMTYPEINDEX_PLAYNUM];// collect separated packets into one (append packets with NO_PTS to the collector)
 int64_t record_duration_us;                                       // calculated duration (from last - first dts) in usec
 mpxp_filesize_t record_duration_bytes;                            // written bytes (stream sizes only!)
 char output_filename[MAX_PATHNAMELEN];                            // output file name
 unsigned long program_control_save;                               // save of mpxplay_programcontrol to enable MPXPLAY_PROGRAMC_CONFIRMEXIT under record
}ffmpeg_external_outfile_infos_s;

#define MPXPLAY_FFMPEGDEMUX_STRUCT_ID (((mpxp_uint32_t)'M' << 24) | ((mpxp_uint32_t)'F' << 16) | ((mpxp_uint32_t)'D' << 8) | (mpxp_uint32_t)'D')

typedef struct ffmpg_demuxer_data_s{
 mpxp_uint32_t struct_id;
 unsigned int flags, outsample_size, streamtype_limit;
 int retcode_demux;
 int errorcount_demux;
 int program_number_current;
 int select_new_program_number;
 int primary_video_stream_index;    // streamtype index of primary video (MPXPLAY_STREAMTYPEINDEX_VIDEO, MPXPLAY_STREAMTYPEINDEX_VIDEOWALL ... MPXPLAY_STREAMTYPEINDEX_MAX)
 struct mpxplay_filehand_buffered_func_s *fbfs;
 void *fbds;
 struct mpxplay_infile_info_s *miis;
 unsigned int primary_file_openmode; // openmode for primary file
 AVInputFormat *primary_file_demuxer;// demuxer for main / primary file
 AVFormatContext *fctx;              // ffmpeg file handler context for main / primary file
 AVPacket *pkt;
 AVFrame *audio_frame;
 int audioframe_codec_id;             // saved AV_CODEC_ID_ (for console versions only)
#if MPXPLAY_USE_FFMPEG_V7X
 AVChannelLayout audioframe_channel_layout;
#else
 mpxp_uint64_t audioframe_channel_layout;  // saved channel layout
#endif
 int audioframe_samples_per_channel;  // samples per channel in audio_frame
 int audioframe_copy_sampleblocksize; // copy blocksize in samples (if we spilt a big frame for better a/v sync)
 int audioframe_copy_samplepos;       // sample pos of copy in audio_frame
 mpxplay_packetlist_t *audiodec_curr_pktlist_elem; // current decoder packet
#ifdef INFFMP_USE_DEMUXER_MUTEX
 void *mutexhnd_demuxer;            // mutex handler for demuxing (seek vs read thread)
#endif
 void *mutexhnd_ffmpeg;             // mutex handler for decoding
 mpxp_int64_t avsync_timestamp, avsync_clocktime;  // timestamp of audio, in AV_TIME_BASE
 mpxp_int64_t avsync_videotimestamp;// timestamp of displayed first video frame
 mpxp_int64_t seek_request_pos;     // in AV_TIME_BASE or byte position of the seek
 unsigned int seek_request_flags;   // flags for av_seek_frame, from FFMPG_infile_fseek_av to in_ffmpgdec_demux_read_packets
 int seek_request_retcode;          // result of the seek handled in an other thread
 int audioctx_init_error_count;     // a delay if audio context is not matching with the packet context (and because of this the packet is not used)
 int audiosync_live_init_error_count; // a delay if A/V is out of sync at live streams (INFFMPG_TIMESTAMP_LIVE_MAX_AVDIFFERENCE)
 mpxp_bool_t videowall_mode_enabled;// demux and send all video streams to decoder thread
 mpxp_int64_t stream_last_pts[MPXPLAY_STREAMTYPEINDEX_NUM];
 int select_new_stream_number[MPXPLAY_STREAMTYPEINDEX_NUM];
 int selected_stream_number[MPXPLAY_STREAMTYPEINDEX_NUM];
 unsigned int nb_streams[MPXPLAY_STREAMTYPEINDEX_NUM];
 unsigned int nb_frame_mismatches[MPXPLAY_STREAMTYPEINDEX_NUM];
 struct ffmpeg_external_files_info_s external_file_infos[MPXPLAY_STREAMTYPEINDEX_NUM];
 unsigned int stream_flags[MPXPLAY_STREAMTYPEINDEX_MAX];
 int selected_ff_stream_index[MPXPLAY_STREAMTYPEINDEX_MAX];
 AVStream *selected_avstream[MPXPLAY_STREAMTYPEINDEX_MAX];
 AVCodec *avcodecs[MPXPLAY_STREAMTYPEINDEX_MAX];
 AVCodecContext *codec_ctx[MPXPLAY_STREAMTYPEINDEX_MAX];
 unsigned int codecctx_seq_counters[MPXPLAY_STREAMTYPEINDEX_MAX];     // sequential counter of codec_ctx (to identify obsolete packet ctx)
 mpxplay_packetqueue_t packet_queues[MPXPLAY_STREAMTYPEINDEX_MAX];    // audio/video data (frame) packets
 mpxplay_packetqueue_t codecctx_queues[MPXPLAY_STREAMTYPEINDEX_MAX];  // audio/video codec contexts
 ffmpeg_external_outfile_infos_s recorded_file_infos;
}ffmpg_demuxer_data_s;

#ifdef __cplusplus
extern "C" {
#endif

// in_fmpeg.c
extern mpxp_bool_t infmpeg_is_fileformat_video_stream(AVFormatContext *fctx);
extern mpxp_bool_t infmpeg_is_fileformat_real_stream(AVFormatContext *fctx);
extern int  in_fmpeg_audio_codecid_to_waveid(struct ffmpg_demuxer_data_s *ffmpi,struct mpxplay_infile_info_s *miis, AVFrame *audio_frame);
extern void inffmpg_tags_update(struct mpxplay_infile_info_s *miis, void *fbds, AVDictionary *metadata, unsigned int cmd);
// ffmppars.c
extern int in_ffmppars_parse_stream_header(struct ffmpg_demuxer_data_s *ffmpi, unsigned int stream_count_min);
extern mpxp_int64_t in_ffmppars_get_stream_duration_pts(struct ffmpeg_external_files_info_s *extfilehandler, int primary_ff_stream_idx);
// ffmpgdec.c
extern void in_ffmpgdec_avsync_assign(struct ffmpg_demuxer_data_s *ffmpi, mpxp_int64_t pts);
extern mpxp_int64_t in_ffmpgdec_get_avpacket_timestamp_fctx(AVFormatContext *fctx, int primary_ff_stream_idx, mpxp_int64_t pkt_ts);
extern mpxp_int64_t in_ffmpgdec_get_avpacket_ts_timestamp(struct ffmpg_demuxer_data_s *ffmpi, unsigned int streamtype_index, mpxp_int64_t pkt_ts);
extern mpxp_int64_t in_ffmpgdec_get_avpacket_timestamp(struct ffmpg_demuxer_data_s *ffmpi, unsigned int streamtype_index, AVPacket *pkt);
extern mpxp_int64_t in_ffmpgdec_select_avframe_pts(AVFrame *avframe);
extern mpxp_int64_t in_ffmpgdec_get_avframe_timestamp(struct ffmpg_demuxer_data_s *ffmpi, unsigned int streamtype_index, AVFrame *avframe);
extern void mpxplay_in_ffmpgdec_hwdec_override_avcodec(AVCodecParameters *codecpar, AVCodec **codec_av_new_p);
extern void in_ffmpgdec_hwdec_deinit(AVCodecContext *codec_ctx);
extern int  in_ffmpgdec_infile_callback(mpxp_ptrsize_t demuxer_data, unsigned int control, mpxp_ptrsize_t arg1, mpxp_ptrsize_t arg2, int timeout_ms);
// ffmpadec.c
extern int in_ffmpgdec_decode_audio(struct ffmpg_demuxer_data_s *ffmpi, struct mpxplay_infile_info_s *miis);
// ffmpdmux.c
extern void in_ffmpdmux_seek_process_all(struct ffmpg_demuxer_data_s *ffmpi);
extern void in_ffmpdmux_read_packets(struct ffmpg_demuxer_data_s *ffmpi);
// ffmpepg.c
extern void in_ffmp_epg_mpegts_demux_extfile(struct ffmpeg_external_files_info_s *extfilehandler, uint8_t *dataptr, int datalen);
extern void in_ffmp_epg_mpegts_demux_epginfo(struct ffmpg_epg_info_s *epg_infos, uint8_t *dataptr, int datalen);
extern void in_ffmp_epg_mpegts_clearbuf_extfile(struct ffmpeg_external_files_info_s *extfilehandler);
extern void in_ffmp_epg_mpegts_clearbuf_epginfo(struct ffmpg_epg_info_s *epg_infos);
extern void in_ffmp_epg_mpegts_close(struct ffmpg_epg_info_s *epg_infos);
extern struct mpxplay_dvb_epg_program_data_s *mpxplay_inffmp_epg_search_programdata_by_programid(struct ffmpg_epg_info_s *epg_infos, int program_id);
extern struct mpxplay_dvb_epgeventlist_t *mpxplay_inffmp_epg_prepare_epginfolist(struct ffmpg_demuxer_data_s *ffmpi, int streamtype_index);
extern void mpxplay_inffmp_epg_clear_epginfolist(struct mpxplay_dvb_epgeventlist_t *epg_list);
// ffmpfile.c
extern int  in_ffmpfile_filelist_file_add(struct ffmpg_demuxer_data_s *ffmpi, char *filename, int streamtype_index);
extern int  in_ffmpfile_filelist_files_add_lfcbds(struct ffmpg_demuxer_data_s *ffmpi, struct mpxplay_loadfile_callbackdata_s *mcbs);
extern void in_ffmpfile_filelist_files_clear_lfcbds(struct mpxplay_loadfile_callbackdata_s *mcbs);
extern void in_ffmpfile_filelist_load_list_by_ext(struct ffmpeg_external_files_info_s *extfiles, char *video_filename, unsigned int streamtype_index);
extern void in_ffmpfile_filelist_close(struct ffmpeg_external_files_info_s *extfiles);
extern int  in_ffmpfile_filelist_search_by_language(struct ffmpeg_external_files_info_s *extfiles, char *lang_code);
extern int  in_ffmpfile_file_open_by_streamindex(struct ffmpg_demuxer_data_s *ffmpi, unsigned int stream_type, int stream_index, AVStream **selected_avstream, AVCodec **codec_av_new);
extern void in_ffmpfile_file_close(struct ffmpeg_external_files_info_s *extfiles);
extern int  in_ffmpfile_file_packet_read(struct ffmpeg_external_files_info_s *extfiles, AVPacket *pkt);
extern int  in_ffmpfile_file_seek(struct ffmpeg_external_files_info_s *extfiles, mpxp_int64_t seek_pos, unsigned int seek_flags);
#ifdef MPXPLAY_GUI_QT
extern int  in_ffmpfile_file_output_init(struct ffmpg_demuxer_data_s *ffmpi, struct mpxplay_loadfile_callbackdata_s *mcbs);
extern mpxp_bool_t in_ffmpfile_file_output_running(struct ffmpg_demuxer_data_s *ffmpi);
extern int  in_ffmpfile_file_output_writeframe(struct ffmpg_demuxer_data_s *ffmpi, AVFormatContext *avform_in, AVPacket *pkt_in);
extern void in_ffmpfile_file_output_close(struct ffmpg_demuxer_data_s *ffmpi);
#else
#define in_ffmpfile_file_output_init(ffmpi, avform_in)
#define in_ffmpfile_file_output_writeframe(ffmpi, avform_in, pkt)
#define in_ffmpfile_file_output_close(ffmpi)
#endif
// ffmplang.c
extern const char *mpxplay_ffmplang_search_in_iso639_1to2_convs(const char *langcode_iso639_1_to_search);
extern const char *mpxplay_ffmplang_getlangname_by_langcode(const char *lang_code);
extern int mpxplay_ffmplang_get_language_fields(const char ***lang_codes_ptr, const char ***lang_names_ptr);
// ffmpqueu.c
extern unsigned int mpxplay_ffmpgdec_queue_clear_to_elemctx(mpxplay_packetqueue_t *packet_queue, void *ctx);
extern void in_ffmpgdec_packet_queues_clear(struct ffmpg_demuxer_data_s *ffmpi, mpxplay_packetqueue_t *packet_queue);
extern void in_ffmpgdec_packet_queues_init(mpxplay_packetqueue_t *packet_queue);
extern void in_ffmpgdec_packet_queues_close(struct ffmpg_demuxer_data_s *ffmpi, mpxplay_packetqueue_t *packet_queue);
// ffmpstrm.c
extern enum AVMediaType in_ffmpstrm_streamtypeindex_to_avmediatype(unsigned int streamtype_index);
extern mpxp_bool_t in_ffmpgdec_content_has_programs(struct ffmpg_demuxer_data_s *ffmpi);
extern mpxp_bool_t mpxplay_ffmpstrm_is_avstream_parsed(AVStream *st, unsigned int stream_type_idx);
extern AVStream *in_ffmpstrm_find_videostream_and_decoder(AVFormatContext *fctx, unsigned int stream_type, int program_number_select, AVCodec **codec_av_new);
extern mpxp_bool_t in_ffmpstrm_skip_program_auto(struct ffmpg_demuxer_data_s *ffmpi, int prognum_current_id);
extern void in_ffmpstrm_primary_streams_select(struct ffmpg_demuxer_data_s *ffmpi);
extern void in_ffmpstrm_primary_streams_check(struct ffmpg_demuxer_data_s *ffmpi);
extern int  in_ffmpstrm_streams_count(struct ffmpg_demuxer_data_s *ffmpi, int streamtype_index, int *select_stream_number, int *selected_ff_streamindex, AVCodec **codec_av_new);
extern int  in_ffmpstrm_initialize_one_stream(struct ffmpg_demuxer_data_s *ffmpi, int streamtype_index, int select_stream_number);
extern mpxp_bool_t in_ffmpstrm_primary_streams_initialize(struct ffmpg_demuxer_data_s *ffmpi, mpxp_bool_t initial);
extern mpxp_bool_t in_ffmpstrm_all_programs_videostreams_initialize(struct ffmpg_demuxer_data_s *ffmpi);
extern int in_ffmpstrm_all_programs_videostreams_program_id_get(struct ffmpg_demuxer_data_s *ffmpi, int streamtype_index);
extern mpxp_bool_t in_ffmpstrm_all_programs_videostreams_program_select(struct ffmpg_demuxer_data_s *ffmpi, int streamtype_index);
extern void in_ffmpstrm_all_programs_videostreams_terminate(struct ffmpg_demuxer_data_s *ffmpi);

#ifdef __cplusplus
}
#endif

#endif //MPXPLAY_LINK_INFILE_FF_MPEG

#endif //FFMPGDEC_H

