#ifndef mpxplay_textwin_h
#define mpxplay_textwin_h

#ifdef __cplusplus
extern "C" {
#endif

#define TEXTWIN_LOCFLAG_EDITLINE_OVERWRITE   1 // Ins key enables/disables (default is inserting)
//#define TEXTWIN_LOCFLAG_EDITLINE_NONFIRSTKEY 2 // first Ins disables auto-clear

#define TEXTWIN_WINDOWSIZE_MIN_Y 3
#ifdef MPXPLAY_GUI_CONSOLE
#define TEXTWIN_WINDOWSIZE_MAX_Y (textscreen_maxy)
#define TEXTWIN_WINDOWSIZE_MIN_X (textscreen_maxx/2) //((textscreen_maxx*5)/8)
#define TEXTWIN_WINDOWSIZE_MAX_X (textscreen_maxx)
#else
#define TEXTWIN_WINDOWSIZE_MAX_Y 50
#define TEXTWIN_WINDOWSIZE_MIN_X 40
#define TEXTWIN_WINDOWSIZE_MAX_X 80
#endif
#define TEXTWIN_BORDERSIZE_X     4
#define TEXTWIN_BORDERSIZE_Y     2

#define TEXTWIN_WINDOW_SHADOW_X 2
#define TEXTWIN_WINDOW_SHADOW_Y 1

#define TEXTWIN_ITEMNUM_ALLOC 32
#define TEXTWIN_BUTTONS_GAPSIZE 1

#define TEXTWIN_LINETYPE_MSG_STATIC    (1<<0) // static message (can be a pointer)
#define TEXTWIN_LINETYPE_MSG_ALLOCATED (1<<1) // allocate and copy data (if data has passed through stack)
#ifdef MPXPLAY_GUI_CONSOLE
#define TEXTWIN_LINETYPE_MSG_TABLE     TEXTWIN_LINETYPE_MSG_ALLOCATED
#else
#define TEXTWIN_LINETYPE_MSG_TABLE     (1<<2) // static table view (stored in a text field, separated/controlled with \n,\t,\r,\f chars)
#endif
#define TEXTWIN_LINETYPE_MSG_LIST      (1<<3) // select text(line) from a list (dynamic table view)
#define TEXTWIN_LINETYPE_MSG_EDIT      (1<<4) // edit text(line)
#define TEXTWIN_LINETYPE_BUTTON        (1<<5) // buttons
#define TEXTWIN_LINETYPE_SWITCH        (1<<6) // [x] switch
#define TEXTWIN_LINETYPE_PROGRESSBAR   (1<<7) // progress bar (for file copy) !!! QT only, not tested
#define TEXTWIN_LINETYPE_SEPARATOR     (1<<9) // vertical separator line
#define TEXTWIN_LINETYPES_ACTIVE (TEXTWIN_LINETYPE_MSG_LIST|TEXTWIN_LINETYPE_MSG_EDIT|TEXTWIN_LINETYPE_BUTTON|TEXTWIN_LINETYPE_SWITCH) // interactive items

// !!! other (external) flags in display.c (TEXTWIN_EDITFLAG_)
#define TEXTWIN_EDITLINEFLAG_SECMOUSEPOS 0x4000000 // 2. mouse positioning
#define TEXTWIN_EDITLINEFLAG_FIRSTKEY    0x8000000

#define TEXTWIN_ITEM_PROGRESSBAR_FLAG_VERTICAL    (1<<0) // else horizontal
#define TEXTWIN_ITEM_PROGRESSBAR_FLAG_BOTTOMTOTOP (1<<1) // else top to bottom
#define TEXTWIN_ITEM_PROGRESSBAR_FLAG_SHOWPTEXT   (1<<2) // show percent text

#define TEXTWIN_MAX_WINDOWS 1

#define MPXPLAY_TEXTWIN_STRUCT_ID (((mpxp_uint32_t)'M' << 24) | ((mpxp_uint32_t)'T' << 16) | ((mpxp_uint32_t)'W' << 8) | (mpxp_uint32_t)'D')

typedef char *textwin_msgtype_passive_t;
typedef char **textwin_msgtype_active_t;
typedef display_textwin_button_t *textwin_msgtype_button_t;

typedef void (*execfunc_data_t)(void *);
typedef void (*execfunc_nodata_t)(void);

typedef void (*buttonhand_func_t)(void *,unsigned int);

typedef struct textwin_editline_t{
 mpxp_wchar_t *strbuf;
 char *srcstr;
 unsigned int maxdatalen;
 unsigned int line_data_pos;
 unsigned int line_data_begin;
 unsigned int line_data_len;
 unsigned long flags;
}textwin_editline_t;

typedef struct textwin_listlines_t{
 char **listentries;
 unsigned int nb_entries;
 unsigned int winbeginline;
 unsigned int *line_selector_varptr;
}textwin_listlines_t;

typedef struct textwin_switchline_t{
 mpxp_uint32_t *switchvar;
 mpxp_uint32_t switchbit;
 char *switchtext;
}textwin_switchline_t;

typedef struct textwin_progressbar_t{
 unsigned long flags;
 int minval, maxval, value;
}textwin_progressbar_t;

typedef struct textwin_item_t{
 unsigned int type;
 unsigned int flags;
 int xpos,ypos;
 unsigned int xsize,ysize;
 void *data; // can be listlines_t, editline_t, button_t, switchline_t, textwin_progressbar_t, msg (char), table (char)
#ifndef MPXPLAY_GUI_CONSOLE
 void *widget_ptr;
#endif
}textwin_item_t;

typedef struct textwin_window_t{
 mpxp_uint32_t struct_id;
 unsigned int flags;                 // external control (bits are defined in display.h)
 unsigned int locflags;              // internal control
 mpxp_wchar_t *winmem;               // window memory
 unsigned int basecolor,buttoncolor; // colors
 unsigned int xpos,ypos,xsize,ysize; // pos,size

 char *headtext;

 unsigned int nb_buttons;
 buttonhand_func_t *buttonhandlerfunc;
 void *buttonhandlerdata;

 unsigned int nb_items;
 textwin_item_t *item_first;
 unsigned int nb_allocated_items;
 unsigned int item_pos_y;
 int item_selected;
#ifndef MPXPLAY_GUI_CONSOLE
 void *dialog_ptr;
#endif
}textwin_window_t;

extern unsigned int display_textwin_draw_window_items(textwin_window_t *tw);

#ifdef __cplusplus
}
#endif

#endif
