#ifndef MOC_DRIVELINE_H
#define MOC_DRIVELINE_H
 
#include <QWidget>
#include <QtWidgets>
#include <QStandardItemModel>
#include <QPushButton>
#include "moc_dialog_elems.h"

#ifndef DISPQT_MUTEX_TIMEOUT
#define DISPQT_MUTEX_TIMEOUT 3000
#endif

#define DISPQT_DRIVELINE_NB_BUTTONS 4

QT_BEGIN_NAMESPACE
class MainWindow;
QT_END_NAMESPACE

class DriveComboBox : public DispQtDialogElemComboBox
{
Q_OBJECT
public:    
	DriveComboBox(MainWindow *main_window = 0, QWidget *parent = 0, unsigned int sidenum = 0);
	bool drive_list_select_by_tabpath(struct dispqt_playlisteditor_model_config_s *pmc, QString tab_path);
	void showPopup();
	void hidePopup();
	
public Q_SLOTS:
	void handle_Activated(int index);
	void handle_show_popup(void);

Q_SIGNALS:
	void signal_show_popup(void);

protected:
	void keyPressEvent(QKeyEvent *event);

private:
	MainWindow *main_window;
	QWidget *parent_widget;
	unsigned int side_num, selected_line;
	QMutex mutex_drivecombo;
	void call_drivespace_refresh(struct dispqt_playlisteditor_model_config_s *pmc);
	void drive_list_refresh(struct dispqt_playlisteditor_model_config_s *pmc);
};

class EditorDrivespaceInfo : public QLabel
{
Q_OBJECT
public:
	EditorDrivespaceInfo(MainWindow *main_window, QWidget *parent=0);
	void drivespace_style_apply(bool initial);
	void drive_space_refresh(struct dispqt_playlisteditor_model_config_s *pmc, const QString combo_line);

private:
	MainWindow *main_window;
	QString space_text;
	QMutex mutex_spaceinfo;
};

class EditorlinePushbutton : public QPushButton
{
Q_OBJECT
public:
  EditorlinePushbutton(const QString &text_str, QWidget *parent, unsigned int sidenum = 0, unsigned int button_id = 0, MainWindow *mainwindow = 0);
  void button_config_style_apply(bool initial);

public Q_SLOTS:
 	void click();

private:
 	MainWindow *main_window;
	unsigned int button_id, side_num;
};

class EditorDriveline : public QWidget
{
Q_OBJECT
public:
	EditorDriveline(MainWindow *main_window = 0, QWidget *parent = 0, unsigned int sidenum = 0);
	void driveline_config_style_apply(bool initial);
	DriveComboBox *drive_combobox;
	EditorDrivespaceInfo *drive_space_label;

private:
	QHBoxLayout *driveline_layout;
	EditorlinePushbutton *driveline_buttons[DISPQT_DRIVELINE_NB_BUTTONS];
};

#endif
