#ifndef MOC_MAINWINDOW_H
#define MOC_MAINWINDOW_H

#include <QMainWindow>
#include <QtWidgets>
#include <QStandardItemModel>
#include <QTableView>
#include <QTabWidget>
#include <QBoxLayout>
#include <QtWinExtras/QtWinExtras>
#include "moc_config.h"
#include "mpxplay.h"
#include "playlist/playlist.h"

QT_BEGIN_NAMESPACE
class MainWindow;
class DispQtAVMixerWidget;
class DispQtAVMixerDialog;
class DispQtEPGDialog;
class DispQtTextwinGenerate;
class DispQtVideoPlayer;
class PlaylistEditorWidget;
class DispQtMainwinSeekbar;
class DispQtVideoControlbar;
QT_END_NAMESPACE

enum dispqt_mainwin_widget_ids {
	DISPQT_MAINWIN_WIDGET_VIDEO,
	DISPQT_MAINWIN_WIDGET_SEEKBAR,
	DISPQT_MAINWIN_WIDGET_TOOLBAR,
	DISPQT_MAINWIN_WIDGET_AVMIXER,
	DISPQT_MAINWIN_WIDGET_EDITOR,
	DISPQT_MAINWIN_WIDGET_STATUSLINE,
	DISPQT_MAINWIN_WIDGET_MAX
};

struct dispqt_cfgwinctrl_to_widgetnum_s {
	unsigned long winctrl_bit;
	unsigned long videoctrl_bit;
	enum dispqt_mainwin_widget_ids widgetnum;
	unsigned int stretch_novideo;
	unsigned int stretch_withvideo;
};

#define DISPQT_WINDOW_ACTIVATE_GEOMETRYUPDATE_DELAY 100

enum Mainwindow_SelectLoadType {Mainwindow_SelectLoadFiles = 0, Mainwindow_SelectLoadDir = 1, Mainwindow_SelectLoadUrl = 2, Mainwindow_SelectLoadFileStreams = 3,
	                            Mainwindow_SelectLoadLiveStreams = 4, Mainwindow_SelectRecordFilename = 5};

class MainWindow : public QMainWindow
{
	Q_OBJECT

public:
	MainWindow(QApplication *application = 0, QWidget *parent = 0);
	unsigned long mainwin_keypresscode_catch(unsigned long keycode);
	void mainwin_handle_keypresscode(unsigned long keycode);
	void handle_keypressevent(QKeyEvent *event);
	void mainwin_handle_mousepress_skip_or_seek_event(QMouseEvent *event);
	int mainwin_get_display_number(void);
	int video_get_fullscreen_display_number(void);
	void mainwindow_set_focus(void);
	bool mainwin_guilayout_get_base_colors(enum dispqt_dialog_window_types dialogType, QPalette *color_palette, QColor *color_background, QColor *color_text, unsigned long *color_hexa_background);
	unsigned long mainwin_guilayout_get_type(void);
	unsigned long mainwin_guibkg_get_type(void);
	unsigned long mainwin_guibkg_get_effect(void);
	bool mainwin_guibkg_is_transparent(void);
	bool mainwin_guibkg_setting_is_transparent(void);
	bool mainwin_guibkg_is_colorized(void);
	bool mainwin_guibkg_is_glass(void);
	bool mainwin_guilayout_is_nonclassic(void);
	bool mainwin_guilayout_is_dark_background(void);
	bool mainwin_guilayout_is_translucent_enabled();
	void mainwin_guilayout_toolbutton_setstyle(QToolBar *toolbar, bool initial);
	bool mainwin_is_on_video(void) { return this->is_mainwin_on_video; }
	void mainwin_video_check_show(int x, int y);
	struct mpxplay_loadfile_callbackdata_s *mainwin_urlist_to_loadfilecbs(QList<QUrl> urllist, int sidenum, int tabnum, Mainwindow_SelectLoadType load_type);
	void mainwin_load_files_or_dir(int sidenum, int tabnum, Mainwindow_SelectLoadType loadtype);
	void mainwin_statusbar_message(char *utf8_msg);
	bool mainwin_statusbar_msg_send(char *utf8_msg);
	void mainwin_rebuild_full_window(bool checkflag);

	unsigned int analtabdelay;

	DispQtVideoPlayer *qt_video_player;
	DispQtConfigWindow *config_dialog;
	DispQtEPGDialog *dvbepg_dialog;
	PlaylistEditorWidget *PlaylistEditor;
	DispQtTextwinGenerate *dialog_handler;
	struct mmc_dispqt_config_s *gui_config;
	QFont font_mainwin;
	bool mainwin_initialized;
	unsigned int ms_windows_version;

	QAction *action_play_start, *action_play_stop;
	QAction *action_play_skipback, *action_play_skipforward;
	QAction *action_play_seekback, *action_play_seekforward;
	QAction *action_play_pausenext, *action_play_highlight;
	QAction *action_list_replay, *action_list_id3search, *action_view_videofs, *action_view_videowall;

Q_SIGNALS:
	void signal_close_mainwindow_from_external(void);
	void signal_check_and_apply_translucent_change(void);
	void signal_config_apply(bool);
	void signal_config_dialogwindow_closed(void);
	void signal_avmixer_set_avformat(bool video);
	void signal_avmixer_sliders_reload(bool volume_only);
	void signal_media_set_currfileinfos(struct dispqt_currfileinfo_s *cur);
	void signal_media_set_timepos(int);
	//void signal_option_timemode_change(unsigned int);
	void signal_video_mainwin_opacity_disable(bool);
	void signal_video_mainwin_wakeup(bool,bool);
	void signal_video_fullscreen(bool full);
	void signal_statusbar_msg_dynamic(void);
	void signal_mixer_dialog_close(void);
	void signal_action_file_openfiles(void);
	void signal_event_mainwindow_wakeup(void);
	void signal_event_mainwindow_statechange(void);
	void signal_event_mainwindow_activate(QEvent::Type event_type);
	void signal_video_ffmpeg_frame_display(int video_index, unsigned int flags, void *videoout_frame, void *subtitle_infos, unsigned int refresh_type);
	void signal_video_mouse_cursor_show(bool timed);
	void signal_seekbar_preview_send(void *preview_frame_p);
	void signal_dvbepgdialog_send_dtvdbase_epginfos(void *protocol_data, char *currfilename);
	void signal_dvbepgdialog_send_scaninfos(void *protocol_data);
	void signal_dvbepgdialog_send_localfile_epginfos(void *protocol_data, char *currfilename);

protected:
	void resizeEvent(QResizeEvent *event);
	void moveEvent(QMoveEvent *);
	void keyPressEvent(QKeyEvent *event);
	void closeEvent(QCloseEvent *);
	bool event(QEvent *event);
	bool nativeEvent(const QByteArray &, void *message, long *);

public slots:
	void CloseWindowTriggeredfromExternal(void);
	void CloseWindowInitiateExternal(void);
	void config_apply(bool reopen_always);
	void config_dialogwindow_closed();
	void commandermode_switch(bool enable) { this->action_view_commander->setChecked(enable); }
	void video_fullscreen_mainwin_opacity_disable(bool);
	void video_fullscreen_mainwin_wakeup(bool to_top, bool fast_hide);
	void video_fullscreen_switch(bool full);
	void event_mixer_dialog_close(void);
	void exit_handler(QPrivateSignal signum);
	void exit_handler_commit(QSessionManager &sessman);
	void play_start_or_pause();
	void play_stop();
	void play_skip_back();
	void play_skip_forward();
	void actfunc_file_addfiles(void);
	void actfunc_options_videofs(void);
	void actfunc_options_videowall(void);
	void actfunc_tools_dvbepg_from_contextmenu(void);
	void actfunc_tools_dvbepg_from_mainwindow(void);
	void mainwin_video_ffmpeg_frame_display(int video_index, unsigned int flags, void *videoout_frame, void *subtitle_infos, unsigned int refresh_type);
	void mainwin_video_mouse_cursor_show(bool timed);
	void mainwin_seekbar_preview_send(void *preview_frame_p);
	void mainwin_dvbepgdialog_send_dtvdbase_epginfos(void *protocol_data, char *currfilename);
	void mainwin_dvbepgdialog_send_scaninfos(void *protocol_data);
	void mainwin_dvbepgdialog_send_localfile_epginfos(void *protocol_data, char *currfilename);

private slots:
    void mainwin_geometry_update(void);
    void mainwin_check_and_apply_translucent_change(void);
	void mainwin_avmixer_set_avformat(bool video);
	void mainwin_avmixer_sliders_reload(bool volume_only);
	void mainwin_media_set_currfileinfos(struct dispqt_currfileinfo_s *cur);
	void mainwin_media_set_timepos(int);
	//void mainwin_option_timemode_change(unsigned int);
	void mainwindow_opacity_shotwindowopacitytimer(long opacity_new);
	void mainwindow_opacity_setwindowopacity(long opacity_new);
	void mainwindow_opacity_timed_change(void);
	bool mainwindow_opacity_start(bool hide, bool fast_hide);
	bool mainwindow_opacity_hide_start(void);
	void mainwin_statusbar_msg_recv(void);
	void mainwin_handle_mousepress_timer(void);
	void mainwin_event_window_wakeup(void);
	void mainwin_event_window_statechange(void);
	void mainwin_event_window_activate(QEvent::Type event_type);
	void mainwin_event_desktopscreen_countchange(int change);
	void mainwin_event_desktopscreen_resize(int scrnum);

	void actfunc_file_adddir(void);
	void actfunc_file_addurl(void);
	void actfunc_file_info(void);
	void actfunc_file_edit(void);
	void actfunc_file_rename(void);
	void actfunc_file_copy(void);
	void actfunc_file_move(void);
	void actfunc_file_del(void);

	void play_seek_back();
	void play_seek_forward();
	void play_seek_faster_back();
	void play_seek_faster_forward();
	void actfunc_play_pausenext();
	void actfunc_play_highlight(void);
	void actfunc_play_highlight_movie(int frame);

	void actfunc_list_gotocurr(void);
	void actfunc_list_comparedirs(void);
	void actfunc_list_index_insert(void);
	void actfunc_list_index_remove(void);
	void actfunc_list_replay(void);
	void actfunc_list_random(void);
	void actfunc_list_subdirlist();
	void actfunc_list_id3search();

	void actfunc_options_commandermode(void);
	void actfunc_options_avmixer(void);
	void actfunc_view_editorsw(void);
	void actfunc_options_mainwin_transparent(void);

	void actfunc_tools_configure(void);
	void actfunc_tools_ftp_connect(void);
	void actfunc_tools_ftp_disconnect(void);

	void actfunc_help_help(void);
	void actfunc_help_about();

private:
	void mainwin_connect_signals(void);
	void mainwin_disconnect_signals(void);
	void mainwin_delete_independent_objects(void);
	void config_style_apply(bool initial);
	void mainwin_config_style_color(void);
	bool mainwin_guibkg_is_translucent(void);
	bool mainwin_is_translucent_supported(void);
	bool mainwin_is_transparent_supported(void);
	bool mainwin_set_translucent_and_colors(bool initial);
	void mainwin_translucent_background_update(void);
	void mainwin_translucent_dialogs_update(bool full);
	void mainwin_set_transparent(bool enable, bool initial);
	void mainwindow_set_always_on_top(bool);
	void mainwin_geometry_resize(int w, int h);
	void mainwin_geometry_move(int x, int y);
	void mainwin_geometry_save(void);
	void mainwin_geometry_restore(bool chk_maxi = true);
	bool mainwin_widget_exists(enum dispqt_mainwin_widget_ids);
	int  mainwin_widget_index(enum dispqt_mainwin_widget_ids);
	int  mainwin_widget_stretch(enum dispqt_mainwin_widget_ids);
	bool mainwin_is_underMouse(void);
	bool mainwin_is_hidden_on_videowall(void);
	void createActions();
	void createMenus();
	void createToolBars(bool);
	void mainwin_toolbar_style_apply(bool initial);
	void createVideo(QWidget *parent);
	void createVideoControlbar(bool initial);
	void createSeekbar(bool initial);
	void createAVmixer(bool initial);
	void createEditor(bool initial);
	void createDialogHandler(QWidget *parent);
	void createDVBEPGDialog(QWidget *parent);
	void loadFile(const QString &fileName);
	bool saveFile(const QString &fileName);
	void mainwin_statusbar_init(void);
	void mainwin_statusbar_style_apply(bool initial);

	HWND main_window_handler;
	QWidget *main_widget;
	QBoxLayout *main_layout;
	QWidget *toolbar_widget;
	QHBoxLayout *toolbar_layout;
	DispQtAVMixerWidget *mixer_widget;
	DispQtAVMixerDialog *mixer_dialog;
	DispQtMainwinSeekbar *mainwin_seekbar;
	DispQtVideoControlbar *video_controlbar;

	DispQtDialogElemMenubar *mainwin_menubar;
	QMenu *fileMenu, *playMenu, *listMenu, *viewMenu, *toolsMenu, *helpMenu;
	QToolBar *fileToolBar, *playToolBar, *optionsToolBar;

	QAction *action_file_openfiles, *action_file_opendir, *action_file_openurl, *action_file_info, *action_file_edit, *action_file_rename, *action_file_copy, *action_file_move, *action_file_del, *action_file_exit;
	QAction *action_list_gotocurr, *action_list_comparedirs, *action_list_index_insert, *action_list_index_remove, *action_list_random, *action_list_subdirlist;
	QAction *action_view_commander, *action_view_avmixer, *action_view_editorsw, *action_view_mainwin_transparent;
	QAction *action_options_configure, *action_options_dvbepg, *action_options_ftp_connect, *action_options_ftp_disconnect;
	QAction *action_help_help, *action_help_about;
	QMovie *actmovie_play_highlight;

	QAction *action_statusbar_msg_dynamic;
	unsigned int act_statusbar_userdataid_msg;
	QString str_statusline;
	QMutex mutex_mainwindow, mutex_opacity, mutex_statusline;

	unsigned long prev_gui_layout, prev_gui_bkgtype, prev_gui_bkgeffect, prev_mainwin_control, prev_video_control;
	bool is_winos_composition_enabled, is_winos_highcontrasttheme_used;
	bool is_mainwin_on_video, mainwin_opacity_forbidd, mainwin_opacity_status_showout;
	long mainwin_opacity_curr, mainwin_opacity_steps, mainwin_opacity_target;
	long mainwin_opacity_keep_ms, mainwin_opacity_showout_interval_ms;
	int mainwin_video_window_size_y;
	QTimer *timer_mainwin_onvideo;
	QTimer timer_mainwin_mousepress, timer_mainwin_mousepress_repeat, timer_mainwin_geometryupdate;
	Qt::MouseButton mainwin_mousepress_button;
	bool avmixer_create_lock, mainwin_gsave_lock;

	QPalette color_palette;
	QPixmap bkgnd_image;
	QColor color_dialog_background, color_dialog_text;
	unsigned long color_background_hexa_curr, color_background_hexa_last;

	void mainwin_taskbar_init(void);
	void mainwin_taskbar_set_currfileinfos(struct dispqt_currfileinfo_s *cur);
	void mainwin_taskbar_set_timepos(int new_timepos_ms);

	QWinTaskbarProgress *mainwin_taskbar_progress;
	QWinThumbnailToolBar *mainwin_taskbar_toolbar;
	QWinThumbnailToolButton *mainwin_taskbar_button_play, *mainwin_taskbar_button_stop, *mainwin_taskbar_button_skip_back, *mainwin_taskbar_button_skip_forward;
	QWinThumbnailToolButton *mainwin_taskbar_button_seek_rewind, *mainwin_taskbar_button_seek_forward, *mainwin_taskbar_button_fullscreen;
};

extern unsigned long mpxplay_dispqt_mainwindow_keypress_convert(QKeyEvent *event);
extern bool mpxplay_dispqt_mainwin_check_translucent_available(bool *isHighContrastThemeUsed);

#endif // MOC_MAINWINDOW_H
