//**************************************************************************
//*                     This file is part of the                           *
//*                MMC - Mpxplay Multimedia Commander                      *
//*                   The source code of MMC is                            *
//*        (C) copyright 1998-2013 by PDSoft (Attila Padar)                *
//*                http://mpxplay.sourceforge.net                          *
//*                  email: mpxplay@freemail.hu                            *
//**************************************************************************
//*  This program is distributed in the hope that it will be useful,       *
//*  but WITHOUT ANY WARRANTY{} without even the implied warranty of        *
//*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                  *
//*  Please contact with the author (with me) if you want to use           *
//*  or modify this source.                                                *
//**************************************************************************
//function:

#ifndef moc_textwin_h
#define moc_textwin_h

#include <QtWidgets>
#include <QMessageBox>
#include "moc_dialog_elems.h"
#include "disp_qt.h"
#include "display/display.h"
#include "display/textwin.h"
#include "newfunc/newfunc.h"

QT_BEGIN_NAMESPACE
class MainWindow;
class DispQtTextwinDialog;
class DispQtTextwinButton;
QT_END_NAMESPACE

#define DISPQT_TEXTWIN_WINSIZE_MIN_X   40
#define DISPQT_TEXTWIN_WINSIZE_MIN_Y    6

#define DISPQT_TEXTWIN_CFGTYPE_OPEN    1
#define DISPQT_TEXTWIN_CFGTYPE_UPDMSG  2
#define DISPQT_TEXTWIN_CFGTYPE_UPDVAL  3
#define DISPQT_TEXTWIN_CFGTYPE_UPDHEAD 4
#define DISPQT_TEXTWIN_CFGTYPE_CLOSE   5

#define DISPQT_TEXTWIN_MUTEX_TIMEOUT   DISPQT_MUTEX_TIMEOUT

struct dispqt_textwin_config_s {
	unsigned int cfg_type;
	void *tw_update;
	int itemnum;
	char *msg;
	int value;
};

struct dispqt_textwin_execfunc_t {
	textwin_window_t *tw;
	void *buttonhandlerfunc;
	void *buttonhandlerdata;
	unsigned int extkey;
	unsigned int flags;
	unsigned int nb_buttons;
};

class DispQtTextwinButton : public DispQtDialogElemPushButton
{
Q_OBJECT
public:
	DispQtTextwinButton(MainWindow *mainwindow = 0, QWidget *parent = 0, textwin_window_t *tw = 0, textwin_item_t *it = 0);
	~DispQtTextwinButton(){}

public Q_SLOTS:
	void textwin_button_handler(bool checked);

protected:
	void keyPressEvent(QKeyEvent *event);

private:
	MainWindow *main_window;
	QWidget *parent_widget;
	textwin_window_t *tw_data;
	unsigned int button_keycode; // 16 bit DOS scancode
	QMutex mutex_tw;
	QMutex mutex_dte;
};

class DispQtTextwinListSelect : public QTableWidget
{
Q_OBJECT
public:
	DispQtTextwinListSelect(int rows, int columns, unsigned int *line_selector_varptr, QWidget *parent = 0);
	~DispQtTextwinListSelect(){}

private slots:
	void textwinlist_select_changed();
	void doubleClickedSlot(QModelIndex index);

private:
	DispQtTextwinDialog *parent_dialog;
	unsigned int *line_selector_varptr;
};

class DispQtTextwinDialog : public DispQtDialogElemWindow
{
Q_OBJECT
public:
	DispQtTextwinDialog(MainWindow *main_window = 0, QWidget *parent = 0, textwin_window_t *tw = 0);
	~DispQtTextwinDialog();
	void textwindialog_close_event(void);
	void textwindialog_update_msg(struct textwin_window_t *tw, int itemnum, char *msg);
	void textwindialog_msg_table_draw(QGridLayout *gdl, int &lasty, textwin_item_t *it, bool update, char *upd_msg);
	void textwindialog_update_itemwidget(struct dispqt_textwin_config_s *dtc);
	void textwindialog_save_modifications(void);
	inline DispQtTextwinButton *textwindialog_first_button(void) { return this->first_button; }

protected:
	void keyPressEvent(QKeyEvent *event);
	void closeEvent(QCloseEvent *);
	void reject();

private:
	MainWindow *main_window;
	QWidget *parent_widget;
	QGridLayout *gdl_table;
	textwin_window_t *tw_data;
	DispQtTextwinButton *first_button;
	mpxp_bool_t ignore_reject;
	QMutex mutex_tw;
	QMutex mutex_dte;
	QFont font_dialog;
};

class DispQtTextwinGenerate : public QObject
{
Q_OBJECT
public:
	DispQtTextwinGenerate(MainWindow *main_window = 0, QWidget *parent = 0);
	~DispQtTextwinGenerate(){};
	bool is_dialog_open(void);
	bool was_dialog_used(void);
	void dialog_open_decrement(void);

Q_SIGNALS:
	void signal_textwinopen(textwin_window_t *tw);
	void signal_textwindelete(textwin_window_t *tw);
	void signal_textwinupdate(struct dispqt_textwin_config_s *dtc);

public slots:
	void textwin_open(textwin_window_t *tw);
	void textwin_delete(textwin_window_t *tw);
	void textwin_update(struct dispqt_textwin_config_s *dtc);

private:
	void dialog_open_increment(void);
	MainWindow *main_window;
	QWidget *parent_widget;
	int dialog_open_counter;
	bool dialog_was_used;
	QMutex mutex_counter;
};

#endif // moc_textwin_h
