#ifndef MOC_VIDEOCONTROLBAR_H
#define MOC_VIDEOCONTROLBAR_H
 
#include <QWidget>
#include <QtWidgets>
#include "disp_qt.h"
#include "moc_dialog_elems.h"

#define DISPQT_VIDEOCTRLBAR_OPACITY_MIN             0 //
#define DISPQT_VIDEOCTRLBAR_OPACITY_MAX           100 //
#define DISPQT_VIDEOCTRLBAR_FADEOUT_TIMERINTERVAL  18 // fadeout timer interval
#define DISPQT_VIDEOCTRLBAR_FADEOUT_OPACITYSTEP    10 // fadeout opacity steps -> 18*10 ~ 200ms to fade out

QT_BEGIN_NAMESPACE
class MainWindow;
class DispQtMainwinSeekslider;
QT_END_NAMESPACE

class DispQtVideoControlbar : public DispQtDialogElemWindow
{
Q_OBJECT
public:
	DispQtVideoControlbar(MainWindow *main_window = 0, QWidget *parent = 0);
	~DispQtVideoControlbar();
	bool videoctrlbar_check_show(int x, int y);
	void videoctrlbar_set_currfileinfos(struct dispqt_currfileinfo_s *cur);

Q_SIGNALS:
	void signal_videoctrlbar_config_style_apply(bool lucent_enable);
	void signal_videoctrlbar_set_show(bool);
	void signal_videoctrlbar_set_timepos(int);
	void signal_videoctrlbar_option_timemode_change(unsigned int);
	void signal_videoctrlbar_seekbar_send_seekpreview(void *preview_frame_p);

public Q_SLOTS:
	void videoctrlbar_config_style_apply(bool);
	void videoctrlbar_set_show(bool);
	void videoctrlbar_set_timepos(int);
	void videoctrlbar_option_timemode_change(unsigned int);
	void videoctrlbar_seekbar_send_seekpreview(void *preview_frame_p);
	void videoctrlbar_fadeout_window_timerfunc(void);

private Q_SLOTS:
	void videoctrlbar_set_size_and_pos(void);

protected:
	bool event(QEvent *);
	void keyPressEvent(QKeyEvent *event);
	void wheelEvent(QWheelEvent *event);
	void mousePressEvent(QMouseEvent *event);
	void mouseReleaseEvent(QMouseEvent *event);

private:
	void videoctrlbar_show_window(void);
	void videoctrlbar_hide_window(void);
	void videoctrlbar_fadeout_window_start(void);
	MainWindow *main_window;
	DispQtMainwinSeekslider *seek_slider;
	bool is_show_enabled, is_headerless_window, is_window_automoved, is_window_manualmoved;
	QToolBar *optionToolBar, *playToolBar;
	QLabel *number;
	int time_len_ms, opacity_max, opacity_curr, calculated_winpos_y, calculated_winsize_y;
	QString current_title;
	QTimer timer_fadeout, timer_refresh;
};

#endif // MOC_VIDEOCONTROLBAR_H
