#ifndef MOC_VIDEO_QT_H
#define MOC_VIDEO_QT_H
 
#include <QWidget>
#include <QtWidgets>
#ifdef MPXPLAY_LINK_QTMEDIA
#include <QtMultimediaWidgets/QVideoWidget>
#endif
#include "moc_config.h"
#ifdef MPXPLAY_LINK_QTMEDIA
#include <QtMultimedia/QMediaPlayer>
#endif
#ifdef MPXPLAY_LINK_ORIGINAL_FFMPEG
#include "moc_video_render.h"
#ifdef __cplusplus
extern "C" {
#endif
#include <libavutil/imgutils.h>
#include <libswscale/swscale.h>
#include <libavfilter/buffersink.h>
#include <libavfilter/buffersrc.h>
#include <libavutil/channel_layout.h>
#include <libavutil/opt.h>

extern unsigned int mpxplay_signal_events;
extern unsigned long mpxplay_config_videoplayer_control, mpxplay_config_video_audiovisualization_type;
extern struct mpxplay_video_renderer_info_s mpxplay_video_render_infos; // declared in ffmpgdec.c

#ifdef __cplusplus
}
#endif // __cplusplus
#endif // MPXPLAY_LINK_ORIGINAL_FFMPEG

QT_BEGIN_NAMESPACE
class MainWindow;
class DispQtVideoEventFilter;
QT_END_NAMESPACE

//#define DISPQT_VIDEO_SCHEDULER_USE_DECODER_THREAD 1 // use separated decoder thread (else call decoder process from scheduler thread)
#define DISPQT_VIDEO_SCHEDULER_USE_CONST_DECODER_THREAD 1 // use constant separated decoder thread (else open a new thread for each file)
#define DISPQT_VIDEO_SCHEDULER_USE_OUTPUT_QUEUE 1 // put decoded frames in an output queue (else hold only one frame in videoframe_pktlist_elem)
//#define DISPQT_VIDEO_SCHEDULER_USE_COND_SIGNAL 1 // use pds_threads_cond_signal to wake up decoder thread (it doesn't help)
#define DISPQT_VIDEO_DECODER_DETECT_D3D_FAILURE  1 // detect d3d context hanging
//#define DISPQT_VIDEO_DECODER_USE_GPU_FLUSH 1 // causes more problem than it solves

#define DISPQT_VIDEO_OPEN_TIMEOUT  5000
#define DISPQT_VIDEO_MUTEX_TIMEOUT DISPQT_MUTEX_TIMEOUT  // 5000

#define DISPQT_VIDEO_CURSORHIDE_TIMEOUT 3000

#define DISPQT_VIDEOWIDGET_SINGLECLICK_TIMEOUTMS 300
#define DISPQT_VIDEOWIDGET_DOUBLECLICK_TIMEOUTMS 300

#define DISPQT_VIDEOWIDGET_CMENUHIDE_TIMEOUTMS 100

#define DISPQT_FFMPEG_WORKERTHREAD_REFRESH_MS 10

#define DISPQT_VIDEO_PROCESS_BUFFERALIGNMENT 16   // (don't use 32, it seems to be buggy in FFmpeg -> segmentation fault) (check)

#define DISPQT_AVFRAME_FLAG_STILLPIC      (1 << 29)  // AVFrame extra flag: still picture
#define DISPQT_AVFRAME_FLAG_NOSKIPFRAME   (1 << 30)  // AVFrame extra flag: disable (for visualization video frame)
#define DISPQT_AVFRAME_FLAG_AR_WINDOW     (1 << 31)  // AVFrame extra flag: use window aspect ratio (for visualization video frame)
#define DISPQT_AVFRAME_FLAGS_MMC          0xF0000000

#define DISPQT_VIDEOFILTER_PROGRESSIVE_DEINTERLACE_MAX_WIDTH     4200 // maximum Width for deinterlace for progressive frames
#define DISPQT_VIDEOFILTER_DEINTERLACE_SWDUPLICATEDFPS_MAX_WIDTH 2000 // maximum Width for sw frame duplication for interlaced frames
#define DISPQT_VIDEOFILTER_DEINTERLACE_HWDUPLICATEDFPS_MAX_WIDTH 4200 // maximum Width for hw (d3d11) frame duplication in deinterlace process

#define DISPQT_VIDEOFILTER_INVALID_VALUE -1000000000  // used to identify the initial non variable_ptr ffmpeg elem config statuses

#define DISPQT_VIDEOFILTER_APPLYRETBIT_NOFILTERAPPLY       0
#define DISPQT_VIDEOFILTER_APPLYRETBIT_INPUTFRAME_PROCESSED (1 << 0)
#define DISPQT_VIDEOFILTER_APPLYRETBIT_OUTPUTFRAME_PRODUCED (1 << 1)

#define DISPQT_VIDEOFILTER_ELEMTYPE_BOOLEAN  (1 << 0)
#define DISPQT_VIDEOFILTER_ELEMTYPE_INTEGER  (1 << 1)
#define DISPQT_VIDEOFILTER_ELEMTYPE_FLOAT    (1 << 2)

#define DISPQT_VIDEOFILTER_PROCESSFLAG_DEFAULT   (1 << 0) // using of this filter is enabled if input/output formats differ and no other filter is enabled
#define DISPQT_VIDEOFILTER_PROCESSFLAG_DEPENDANT (1 << 1) // using of this filter is enabled only if other filters are used (pad at eq)
#define DISPQT_VIDEOFILTER_PROCESSFLAG_AUDIOSRC  (1 << 2) // audio source

#define DISPQT_VIDEOFILTER_NAMES_COLLECTION_BUFSIZE 512

//#define DISPQT_VIDEO_AUTOCROP_UPDATE          -1  // at crop mode change
#define DISPQT_VIDEO_AUTOCROP_COUNTER_REFRESH  1  // at seeking or at window resize
#define DISPQT_VIDEO_AUTOCROP_COUNTER_INIT     2  // at opening a new video

#ifndef MPXPLAY_SAFE_DELETE_OBJECT
#define MPXPLAY_SAFE_DELETE_OBJECT(o) if(o){auto ob = (o); (o) = NULL; delete ob;}
#endif

enum dispqt_videoframefilter_process_types
{
	DISPQT_VIDEOFRAMEFILTER_PROCESSTYPE_DECODER,
	DISPQT_VIDEOFRAMEFILTER_PROCESSTYPE_VMIXERSLIDER,
	DISPQT_VIDEOFRAMEFILTER_PROCESSTYPE_TRANSFORM,
	DISPQT_VIDEOFRAMEFILTER_PROCESSTYPE_MAX
};

enum dispqt_video_filter_crop_elems {
	DISPQT_VIDEO_FILTERCROP_ELEM_W = DISPQT_VIDEO_VMIXERTYPE_MAX,
	DISPQT_VIDEO_FILTERCROP_ELEM_H,
	DISPQT_VIDEO_FILTERCROP_ELEM_X,
	DISPQT_VIDEO_FILTERCROP_ELEM_Y,
	DISPQT_VIDEO_FILTERCROP_ELEM_MAX,
	DISPQT_VIDEO_FILTERCROP_ELEM_NUM = (DISPQT_VIDEO_FILTERCROP_ELEM_Y - DISPQT_VIDEO_FILTERCROP_ELEM_W + 1)
};

typedef struct dispqt_videofilter_elemdescriptor_s
{
	const char *ffmpeg_option_name;
	const int conf_value_offset;
	const int conf_value_scale;  // at DISPQT_VIDEOFILTER_ELEMTYPE_BOOLEAN, if *variable_ptr == conf_value_scale, then '1' is set, else '0'
	const int conf_value_center;
	int *variable_ptr;
	int last_configured_variable_value;
	const unsigned int flags;
	const int unique_id;
}dispqt_videofilter_elemdescriptor_s;

typedef struct dispqt_videofilter_processdescriptor_s
{
	const char *ffmpeg_filter_name;
	const unsigned int process_type;
	const unsigned int process_flags;
#ifdef MPXPLAY_LINK_ORIGINAL_FFMPEG
	unsigned int (*process_condition_func)(struct mmc_dispqt_config_s *gcfg, AVFrame *inframe, char *filtername_withconfig, unsigned int fnwcbuf_size);
#else
	unsigned int (*process_condition_func)(struct mmc_dispqt_config_s *gcfg);
#endif
	struct dispqt_videofilter_elemdescriptor_s *elemdesc;
}dispqt_videofilter_processdescriptor_s;

class DispQtVideoSurfaceContextMenu : public DispQtDialogElemQmenu
{
Q_OBJECT
public:
	DispQtVideoSurfaceContextMenu(MainWindow *main_window = 0, DispQtVideoEventFilter *parent = 0, QWidget *filtered = 0);
	~DispQtVideoSurfaceContextMenu();
protected:
	void mouseReleaseEvent(QMouseEvent *mevent);

private Q_SLOTS:
	void play_start_or_pause(void);
	void program_exit(void);
#ifdef MPXPLAY_LINK_ORIGINAL_FFMPEG
	void actfunc_audio_visualization_select(QAction *selected_visualization_action);
	void actfunc_file_add_filestreams_to_video(void);
	void actfunc_file_add_livestream_to_video(void);
	void actfunc_file_record_streams_start(void);
	void actfunc_file_record_streams_stop(void);
	void actfunc_video_program_select(QAction *selected_ar_action);
	void actfunc_video_stream_select(QAction *selected_ar_action);
	void actfunc_video_ar_select(QAction *selected_ar_action);
	void actfunc_video_crop_select(QAction *selected_crop_action);
	void actfunc_video_deinterlace_select(QAction *selected_deinterlace_action);
	void actfunc_video_screen_select(QAction *selected_rotation_action);
	void actfunc_video_rotation_select(QAction *selected_rotation_action);
	void actfunc_video_zoom_select(QAction *selected_zoom_action);
	void actfunc_video_videowall_switch(void);
#endif

private:
	MainWindow *main_window;
	DispQtVideoEventFilter *parent_object;
	QWidget *filtered_widget;
	struct mpxplay_programinfo_t *program_list;
	struct mpxplay_streaminfo_t *stream_list;

	DispQtDialogElemQmenu *videocontmenu_sub_audio;
	DispQtDialogElemQmenu *videocontmenu_subaudio_sub_visualization;
	DispQtDialogElemQmenu *videocontmenu_sub_file;
	DispQtDialogElemQmenu *videocontmenu_sub_programs;
	DispQtDialogElemQmenu *videocontmenu_sub_streams;
	DispQtDialogElemQmenu *videocontmenu_sub_video;
	DispQtDialogElemQmenu *videocontmenu_subvideo_sub_aspectratio;
	DispQtDialogElemQmenu *videocontmenu_subvideo_sub_crop;
	DispQtDialogElemQmenu *videocontmenu_subvideo_sub_deinterlace;
	DispQtDialogElemQmenu *videocontmenu_subvideo_sub_rotation;
	DispQtDialogElemQmenu *videocontmenu_subvideo_sub_screen;
	DispQtDialogElemQmenu *videocontmenu_subvideo_sub_zoom;

	QAction *menuaction_filename, *action_play_start, *action_play_stop;
	QAction *action_play_skipback, *action_play_skipforward, *action_view_videofs, *action_show_epgdialog, *action_file_exit;
#ifdef MPXPLAY_LINK_ORIGINAL_FFMPEG
	QAction *actions_audio_visualization_select[DISPQT_AUDIOVISUALIZATIONTYPE_MAX];
	QAction *action_file_addfilestreamstovideo, *action_file_addlivestreamstovideo, *action_file_recordstreams;
	QAction **actions_program_select;
	QAction **actions_stream_select[MPXPLAY_STREAMTYPEINDEX_NUM];
	QAction *actions_video_ar_select[DISPQT_VIDEOFULLSCREENARTYPE_MAX];
	QAction *actions_video_crop_select[DISPQT_VIDEOSCRCROPTYPE_MAX];
	QAction *actions_video_deinterlace_select[DISPQT_VIDEO_DEINTERLACETYPE_MAX];
	QAction *actions_video_rotation_select[DISPQT_VIDEO_ROTATIONTYPE_MAX];
	QAction **actions_video_screen_select;
	QAction *actions_video_zoom_select[DISPQT_VIDEOFULLSCREENZOOMTYPE_MAX];
	QAction *action_video_videowall;
	unsigned int nb_video_screen_selections;
#endif
};

class DispQtVideoEventEPGTooltip : public DispQtDialogElemWindow
{
Q_OBJECT
public:
	DispQtVideoEventEPGTooltip(MainWindow *mainwindow = 0, QWidget *parent = 0, QObject *eventfilter = 0, const QString &EPGeventList = 0, bool isVideoWall = false);

protected:
	bool event(QEvent *event);
	void mouseDoubleClickEvent(QMouseEvent *event);
	void keyPressEvent(QKeyEvent *event);

private:
	MainWindow *main_window;
	QWidget *parent_filtered_widget;
	QObject *parent_event_filter;
	bool is_videowall;
};

class DispQtVideoEventFilter : public QObject
{
Q_OBJECT
public:
	DispQtVideoEventFilter(MainWindow *main_window = 0, QWidget *parent = 0, QWidget *filtered = 0);
	bool get_mousecursor_forbidden_hide(void) { return this->mouse_cursor_forbidden_hide; }
	void mouse_cursor_show_timed(bool timed);
	void mouse_cursor_forbid_hide(bool forbid);
	void video_surface_move(int move_x, int move_y);
	void video_zoom_step(int globalpos_x, int globalpos_y, int direction); // 1: zoomin, -1:zoomout
	void video_callback_call(int globalpos_x, int globalpos_y, unsigned long command, mpxp_ptrsize_t arg1, mpxp_ptrsize_t arg2);
	DispQtVideoSurfaceContextMenu *video_surface_contextmenu;

private Q_SLOTS:
	void mouse_cursor_hide(void);
	void cmenu_about_hide(void);
	void mouse_singleclick_timeouthandler(void);
	void mouse_epgtooltip_presenter_handler(void);
	void mouse_epgtooltip_close(void);

protected:
	bool eventFilter(QObject *watched, QEvent *event);

private:
	bool is_video_fullscreen(void);
	bool is_video_wall_enabled(void);
	void videosurface_get_screen_pos0(void);
	void videosurface_get_pos(QMouseEvent *me, int *pos_x, int *pos_y);
	void videosurface_handle_singleclick(void);
	void videosurface_handle_doubleclick(void);
	void videosurface_handle_moveevent_nobutton(QMouseEvent *me);
	void mouse_epgtooltip_open(int pos_x, int pos_y, int height, char *epg_lst_collected_str, bool is_videwall);
	MainWindow *main_window;
	QWidget *parent_widget, *filtered_widget;
	QString epg_event_list;
	DispQtVideoEventEPGTooltip *epgtooltip_window;
	Qt::MouseButton mouse_pressed_buttons;
	int screen_pos_x0, screen_pos_y0;
	int mouse_last_globalpos_x, mouse_last_globalpos_y;
	int epgtooltip_globalpos_x, epgtooltip_globalpos_y;
	bool mouse_cursor_forbidden_hide, singleclick_event, singleclick_fullsrc_start, fullsrc_curr, is_cursor_overrided;
	QTimer timer_singleclick, timer_doubleclick, timer_mouse_hide, timer_cmenu_hide, timer_epgtooltip_interval, timer_epgtooltip_show;
	QMutex mutex_video;
};

class DispQtVideoFrameFilter : public QObject
{
Q_OBJECT
public:
	DispQtVideoFrameFilter(MainWindow *main_window = 0, QObject *parent = 0, dispqt_videofilter_processdescriptor_s *process_desc = 0, unsigned int nb_procdesc = 0);
	~DispQtVideoFrameFilter();

	int video_filter_close(void);
#ifdef MPXPLAY_LINK_ORIGINAL_FFMPEG
	int video_filter_check(AVFrame *frame_in, int frameout_format);
	int video_filter_apply(AVFrame *frame_in, AVFrame **frame_out, int frameout_format);
#endif
	int getVideoFilterValue(int index);

public Q_SLOTS:
	void resetVideoFilterValues(int process_type);
	void setVideoFilterValue(int index, int value);

private:
#ifdef MPXPLAY_LINK_ORIGINAL_FFMPEG
	void video_filter_opencl_init(void);
	int video_filter_init(AVFrame *inframe, int pixeltype_out);
	int video_filter_config(AVFrame *inframe, int pixeltype_out);
#endif
	dispqt_videofilter_elemdescriptor_s *searchElemByUniqueId(int id, int *process_type);
	bool setVideoFilterInternalValue(int index, int value);

	MainWindow *main_window;
	QObject *parent_object;
	QMutex mutex_filter;
	dispqt_videofilter_processdescriptor_s *videofilter_process_descriptor;
	unsigned int nb_video_filter_process_descriptors;
	dispqt_videofilter_processdescriptor_s *first_selected_process_descriptor;
#ifdef MPXPLAY_LINK_ORIGINAL_FFMPEG
	int videofilter_initialized_width;
	int videofilter_initialized_height;
	int videofilter_initialized_format;
#if MPXPLAY_USE_FFMPEG_V7X
	AVChannelLayout videofilter_initialized_chlayout;
#else
	mpxp_uint64_t videofilter_initialized_chlayout;
#endif
	int videofilter_initialized_samplerate;
	AVFilterContext *videofilter_ffmpeg_buffersrc_ctx;
	AVFilterContext *videofilter_ffmpeg_buffersink_ctx;
	AVFilterGraph *videofilter_ffmpeg_graph;
#if MPXPLAY_DISPQT_ENABLE_OPENCL
	AVBufferRef *opencl_device_ref;
#endif
	char videofilter_ffmpeg_filternames_collection[DISPQT_VIDEOFILTER_NAMES_COLLECTION_BUFSIZE];
#endif
};

#ifdef MPXPLAY_LINK_ORIGINAL_FFMPEG

#define MPXPLAY_VIDEO_WORKDEC_THREAD_SLEEPTIME_DEFAULT    33
#define MPXPLAY_VIDEO_WORKDEC_THREAD_SLEEPTIME_SHORT      10
#define MPXPLAY_VIDEO_WORKDEC_THREAD_SLEEPTIME_HWDEC       5
#define MPXPLAY_VIDEO_WORKDEC_THREAD_CRITICAL_ERROR_COUNT 10

#define MPXPLAY_VIDEO_WORKER_THREAD_SLEEPTIME_DEFAULT      5
#define MPXPLAY_VIDEO_WORKER_THREAD_SLEEPTIME_MIN          0
#define MPXPLAY_VIDEO_WORKER_THREAD_SLEEPTIME_MAX         40

#define INFFMPEG_VIDEO_RENDER_MIN_INTERVAL_MS  (DISPQT_FFMPEG_WORKERTHREAD_REFRESH_MS / 2)   // we never display more than 200 fps
#define INFFMPEG_VIDEO_RENDER_MAX_INTERVAL_MS  1000  // we try to display min. 1 fps in any case (other frames are dropped)
#define INFFMPEG_VIDEO_INITERROR_LIMIT 100  // ca. 1000ms wait with 10ms sleep
#define INFFMPEG_VIDEO_INITCOUNT_LIMIT 25   // for debugging

#define MPXPLAY_VIDEO_WORKDEC_FILTER_RESTORE_DELAY 50 // for video_delay_counter_workdec_filter (in frames) (2 secs at 25 fps)

enum {DISPQT_VIDEOSCHEDULER_RENDERSTAT_NONE = 0, DISPQT_VIDEOSCHEDULER_RENDERSTAT_RENDERED};

typedef struct ffmpegvideo_decoder_s{
	unsigned int flags;                                          // DISPQT_FFMPGVIDEOCALLBACKFLAG_
	unsigned int streamtype_index;                               // MPXPLAY_STREAMTYPEINDEX_
	mpxplay_packetlist_t *video_pktlist_elem;                    // input video frame
	AVFrame *vid_frame_decoded;				                     // decoded video frame in video_workdec.cpp
	int video_last_valid_frame_w, video_last_valid_frame_h;      // for progressive jpeg (to drop small frames)
	int videoctx_init_error_count;                               // INFFMPEG_VIDEO_INITERROR_LIMIT
	int videopkt_init_count;                                     // count packets from the begin (for debug frames)
	int videopkt_send_error_count;                               // count packets cannot send to decoder (for debug frames)
	int video_delay_counter_workdec_filter;                      // wait frames after filter is switched off
	int video_decoder_lost_frames;                               // number of pushed, but not decoded video frames (to switch off KeyframesOnly at videowall)
	mpxp_int64_t video_dec_last_timestamp;
	mpxplay_packetqueue_t videoframe_temp_queue;                 // temporary output frame queue (always local memory buffer)
	mpxplay_packetlist_t *videoframe_temp_elem;                  // output frame packet
#ifdef DISPQT_VIDEO_SCHEDULER_USE_OUTPUT_QUEUE
	mpxplay_packetqueue_t videoframe_output_queue;               // output frame queue (can be local memory or d3d11 texture buffer)
#endif
	mpxplay_packetlist_t *videoframe_pktlist_elem;               // output frame packet
	AVRational videoctx_sample_aspect_ratio;                     // saved sample_aspect_ratio from video_ctx
	AVFrame *video_frame_decoded_preprocessed;                   // produced output video frame by video_workdec (deinterlaced, tonemapped) (old vid_frame_filtered)
	AVCodecContext *video_ctx;                                   // opened video context
	unsigned int videoctx_curr_counter;                          // current video codecctx_counter
	bool resetvideo;                                             // seek (reset decoder, get a new keyframe)
	bool resetfilter;                                            // clear filter infos (like sw deinterlace) (at seek or video stream change)
	bool resetoutqueue;                                          // remove all decoded video frames from the output queue (to not send them to the scheduler at seek or video stream change)
	bool resetcodec;                                             // video codec (possible resolution) change
	bool resetflushcodec;                                        // reset video to skip to a keyframe by flushing stored frames (by mpxplay_dispqt_videoworkdec_videodelay_process_output_drop at large video delay)
	bool is_deinterlacedup_2ndpass;                              // deinterlace duplicated frame 2nd pass
	DispQtVideoFrameFilter *video_frame_filter_workerprocess;    // processing filters (deinterlace)
	int videowall_window_pos_x, videowall_window_pos_y;          // video window x,y position on the videowall
	int videowall_window_width, videowall_window_height;         // video window size on the videowall
	dispqt_video_filter_info_s frame_conv_infos;                 // resize or change pixelformat (convert to renderer texture, seekpreview, videowall)
}ffmpegvideo_decoder_s;

typedef struct ffmpegvideo_callback_command_s{
	unsigned int cmd;
	mpxp_ptrsize_t arg1, arg2;
}ffmpegvideo_callback_command_s;

typedef struct ffmpegvideo_delay_s{
	int video_init_framecounter;                                 // aka 'firstframes' flag, process video delay
	int video_delay_type;                                        // DISPQT_FFMPGVIDEOCALLBACK_VIDEODELAYTYPE_
	int video_delay_large_counter;                               // to control video frame drop (decoder + output) with delay
	int video_delay_framedrop_value;                             // drop 1 or 2 frames sequentially
	int video_delay_framedrop_counter;                           // counter of value
	int video_delay_framedrop_restore_retry;                     // counter to give up full frame restoration
}ffmpegvideo_delay_s;

typedef struct ffmpegvideo_callback_list_s{
	unsigned int flags;                                          // DISPQT_FFMPGVIDEOCALLBACKFLAG_
	mpxplay_infile_callback_t *infile_callback;                  // function and
	mpxp_ptrsize_t infile_passdata;                              // data for a callback call to FFmpeg demuxer context
	unsigned int video_render_status;                            // DISPQT_VIDEOSCHEDULER_RENDERSTAT_
	int video_average_frame_interval;                            // to detect fps (us)
	mpxp_int64_t video_delay_us;                                 // last calculated A/V delay in us
	mpxp_int64_t video_last_del_timestamp;                       // last timestamp of video delay (us)
	mpxp_int64_t video_last_sch_timestamp;                       // last timestamp of scheduler (us)
	mpxp_int64_t video_last_present_time;                        // last present time in absolute msec
	mpxp_int64_t subtitle_begin_timestamp;                       // decoded subtitle display time begin (match with the video timestamp)
	mpxp_int64_t subtitle_end_timestamp;                         // decoded subtitle time end
	mpxplay_packetlist_t *subtitle_pktlist_elem;                 // subtitle input data
	ffmpegvideo_subtitle_info_s *subtitle_infos;                 // stored subtitle out/decoded data
	ffmpegvideo_subtitle_info_s *subtitle_vframe_infos;          // subtitle infos related to the current video frame
	DispQtVideoFrameFilter *video_frame_filter_workerprocess;    // processing filters (deinterlace)
	mpxp_int32_t selected_stream_index;                          // main video stream selection by streamtype_index from the video_decoder_threads
	bool is_videowall_enabled;                                   // use mosaic playing of parallel video streams
	bool is_videowall_disabled_by_decoder;                       // videowall is disabled by decoder (playing audio/radio program without video content)
	int video_wall_artype;                                       // aspect ratio mode of videowall output screen
	int videowall_nb_streams;                                    // number of videos (programs) displayed on the videowall (only the visible streams)
	int videowall_count_streams;                                 // counter for videowall streams (to update nb_streams inline)
	int videowall_nb_windows_x;                                  // number of videos (programs) displayed on the videowall horizontally
	int videowall_nb_windows_y;                                  // number of videos (programs) displayed on the videowall vertically
	int videowall_output_artype;                                 // aspect ratio mode for videowall (derived from video_wall_artype)
	struct ffmpegvideo_callback_list_s *next;
#ifdef DISPQT_VIDEO_SCHEDULER_USE_DECODER_THREAD
	mpxp_thread_id_type videodecoder_thread_id;                  // decoder thread id
#endif
#ifdef DISPQT_VIDEO_SCHEDULER_USE_COND_SIGNAL
	void *videodec_thread_condition_signal_handler;              // to flip-flop scheduler and decoder threads (to avoid starting decoder thread under rendering)
#endif
	mpxp_int64_t videowall_sync_timestamp;                       // sync timestamp of primary video to control/gain other videowall streams
	dispqt_video_filter_format_s videowall_subwindow_format;     // output size and format of a videowall window (sub-picture)
	dispqt_video_filter_format_s videowall_output_format;        // output size and format of the complete videowall
	dispqt_video_filter_info_s subtitle_bitmap_cv_infos;         // ffmpeg_swsctx_pixfmt_conv helper for bitmap subtitle pixfmt conversion
	ffmpegvideo_delay_s videodelays_decoder;                     //
	ffmpegvideo_delay_s videodelays_scheduler;                   //
	ffmpegvideo_callback_command_s callback_command;
	ffmpegvideo_decoder_s video_decoder_threads[MPXPLAY_STREAMTYPEINDEX_MAX];
}ffmpegvideo_callback_list_s;

extern void mpxplay_video_ffmpeg_subtitleinfo_clear(ffmpegvideo_subtitle_info_s *sub_lines);
extern void mpxplay_video_ffmpeg_subtitleinfo_copy(ffmpegvideo_subtitle_info_s *dest_lines, ffmpegvideo_subtitle_info_s *sub_lines);
extern ffmpegvideo_subtitle_info_s *mpxplay_decoderworker_subtitle_get(ffmpegvideo_callback_list_s *cbelem, mpxp_int64_t timestamp_curr_us, bool resetvideo);
extern void mpxplay_decoderworker_subtitle_reset(ffmpegvideo_callback_list_s *cbelem);

extern void mpxplay_dispqt_videoworkdec_videodelay_reset(struct ffmpegvideo_delay_s *video_delays, mpxp_bool_t restart);
extern mpxp_bool_t mpxplay_dispqt_videoworkdec_videodelay_process_output_drop(ffmpegvideo_callback_list_s *cbelem, struct mmc_dispqt_config_s *gui_config,
														struct ffmpegvideo_delay_s *video_delays,
														const mpxp_int32_t fps_limit_interval);

#define DISPQT_FFMPGVIDEO_FRAME_POOL_SIZE_BASE      16
#define DISPQT_FFMPGVIDEO_MAX_QUEUED_TEXTBUFFRAME   (DISPQT_FFMPGVIDEO_FRAME_POOL_SIZE_BASE / 2)      // d3d pool buffer size for sw decoded frames
#define DISPQT_FFMPGVIDEO_MAX_QUEUED_DEC_VIDEOFRAME (DISPQT_FFMPGVIDEO_FRAME_POOL_SIZE_BASE / 2)      // decoded sw video frame buffer size
#define DISPQT_FFMPGVIDEO_MAX_QUEUED_AV1_VIDEOFRAME (DISPQT_FFMPGVIDEO_MAX_QUEUED_DEC_VIDEOFRAME * 3 / 2) // decoded AV1 sw video frame buffer size for high-res (>2k) videos
#define DISPQT_FFMPGVIDEO_MAX_QUEUED_GEN_VIDEOFRAME (DISPQT_FFMPGVIDEO_FRAME_POOL_SIZE_BASE / 3)      // generated video frame buffer size (videowall, visual effect)
#define DISPQT_FFMPGVIDEO_MAX_QUEUED_VISVIDEOFRAME  (DISPQT_FFMPGVIDEO_MAX_QUEUED_GEN_VIDEOFRAME * 5)
#define DISPQT_FFMPGVIDEO_MAX_DELAY_VISVIDEOFRAME   (DISPQT_FFMPGVIDEO_MAX_QUEUED_GEN_VIDEOFRAME * 4)     // max number of video frames difference between audio and video output (else ignore timestamp (skip visual video frame))
#define DISPQT_FFMPGVIDEO_VIDEO_MAX_FRAME_DIFF_US    (15 * AV_TIME_BASE)  // max 15 secs difference between video frames
#define DISPQT_FFMPGVIDEO_AVSYNC_MAX_VALID_DIFF_US   (60 * AV_TIME_BASE)  // probably an incorrect pts received, display output picture (ignore timestamp)
#define DISPQT_FFMPGVIDEO_SUBTITLE_MAX_VIDEO_DIFF_US (10 * AV_TIME_BASE)  // max 10 secs difference between video and subtitle (else don't display subtitle)

#define DISPQT_FFMPGVIDEOCALLBACK_INITFRAMECOUNTER_START 50 // wait for 50 video frames before processing video delay detection
#define DISPQT_FFMPGVIDEOCALLBACK_INITFRAMECOUNTER_DELAY  5 // hold video delay detection for a short time (scheduler)

#define DISPQT_FFMPGVIDEOCALLBACKFLAG_EXITEVENT           (1 << 0)  // stop thread event
#define DISPQT_FFMPGVIDEOCALLBACKFLAG_THEXITDONE          (1 << 1)  // done
#define DISPQT_FFMPGVIDEOCALLBACKFLAG_PAUSEDEC            (1 << 2)  // pause decoding
#define DISPQT_FFMPGVIDEOCALLBACKFLAG_FIRSTFRAME          (1 << 4)  // first displayed frame sign
#define DISPQT_FFMPGVIDEOCALLBACKFLAG_PRIMARYVIDEO        (1 << 5)  // primary video file
#define DISPQT_FFMPGVIDEOCALLBACKFLAG_DISPLAYONEFRAME     (1 << 6)  // display one video frame (in pause)
#define DISPQT_FFMPGVIDEOCALLBACKFLAG_IGNORETIMESTAMP     (1 << 7)  // ignore timestamp sync (after seeking) to display a frame
#define DISPQT_FFMPGVIDEOCALLBACKFLAG_STILLPICT           (1 << 8)  // still picture (aspect ratio and multiply picture frame workaround)
#define DISPQT_FFMPGVIDEOCALLBACKFLAG_VW_AVAILABLE        (1 << 12) // video has multiply programs, videowall is available
#define DISPQT_FFMPGVIDEOCALLBACKFLAG_VW_KEYFRAMES_ONLY   (1 << 13) // decode only keyframes at non-primary videowall windows
#define DISPQT_FFMPGVIDEOCALLBACKFLAG_VW_KEYFRAMES_NO     (1 << 14) // disable decode only keyframes for this window (keyframe decoding run to timeout by video_decoder_lost_frames)
#define DISPQT_FFMPGVIDEOCALLBACKFLAGS_IGNORE_TS (DISPQT_FFMPGVIDEOCALLBACKFLAG_STILLPICT)
// render output control flags
#define DISPQT_FFMPGVIDEOCALLBACKFLAG_RF_PAUSEDPLAY       (1 << 16) // playing is in pause
#define DISPQT_FFMPGVIDEOCALLBACKFLAG_RF_DEINT2NDPASS     (1 << 17) // intermediate frame refresh (no new frame) (for deinterlace frame duplication)
// if DISPQT_VIDEORENDERER_CAPFLAG_PREPRESENT is supported, video output shall handle all of the following flags:
#define DISPQT_FFMPGVIDEOCALLBACKFLAG_RF_NOPRESENT        (1 << 18) // render only, no present (pre-render and buffer image in d3d without displaying)
#define DISPQT_FFMPGVIDEOCALLBACKFLAG_RF_PREPRESENT       (1 << 19) // present previously rendered and buffered image (and don't present a new one after render)
// clear these flags (in video_widget) after using once
#define DISPQT_FFMPGVIDEOCALLBACKFLAGS_ONESHOT (DISPQT_FFMPGVIDEOCALLBACKFLAG_FIRSTFRAME | DISPQT_FFMPGVIDEOCALLBACKFLAG_DISPLAYONEFRAME | DISPQT_FFMPGVIDEOCALLBACKFLAG_IGNORETIMESTAMP \
                                               | DISPQT_FFMPGVIDEOCALLBACKFLAG_RF_DEINT2NDPASS | DISPQT_FFMPGVIDEOCALLBACKFLAG_RF_NOPRESENT | DISPQT_FFMPGVIDEOCALLBACKFLAG_RF_PREPRESENT)

enum {DISPQT_VIDEOSCHEDULER_CONTROL_RUN = 0, DISPQT_VIDEOSCHEDULER_CONTROL_REQ_SUSPEND, DISPQT_VIDEOSCHEDULER_CONTROL_REQ_CLOSE, DISPQT_VIDEOSCHEDULER_STATUS_SUSPENDED, DISPQT_VIDEOSCHEDULER_STATUS_CLOSED};
enum {DISPQT_VIDEOSURFACE_REFRESHTYPE_NONE = 0, DISPQT_VIDEOSURFACE_REFRESHTYPE_UPDATE, DISPQT_VIDEOSURFACE_REFRESHTYPE_RESET, DISPQT_VIDEOSURFACE_REFRESHTYPE_CLEAR, DISPQT_VIDEOSURFACE_REFRESHTYPE_CLOSE};

enum {DISPQT_FFMPGVIDEOCALLBACK_VIDEODELAYPLACE_NONE = 0, DISPQT_FFMPGVIDEOCALLBACK_VIDEODELAYPLACE_BUSY, DISPQT_FFMPGVIDEOCALLBACK_VIDEODELAYPLACE_DECODER, DISPQT_FFMPGVIDEOCALLBACK_VIDEODELAYPLACE_SCHEDULER};
enum {DISPQT_FFMPGVIDEOCALLBACK_VIDEODELAYTYPE_NONE = 0, DISPQT_FFMPGVIDEOCALLBACK_VIDEODELAYTYPE_SMALL, DISPQT_FFMPGVIDEOCALLBACK_VIDEODELAYTYPE_MIDDLE, DISPQT_FFMPGVIDEOCALLBACK_VIDEODELAYTYPE_LARGE, DISPQT_FFMPGVIDEOCALLBACK_VIDEODELAYTYPE_SIGNIFICANT};
enum {DISPQT_FFMPGVIDEOCALLBACK_VIDEODELAYLIMIT_SMALL = 30000, DISPQT_FFMPGVIDEOCALLBACK_VIDEODELAYLIMIT_MIDDLE = 40000, DISPQT_FFMPGVIDEOCALLBACK_VIDEODELAYLIMIT_LARGE = 50000, DISPQT_FFMPGVIDEOCALLBACK_VIDEODELAYLIMIT_SIGNIFICANT = (AV_TIME_BASE / 2), DISPQT_FFMPGVIDEOCALLBACK_VIDEODELAYLIMIT_SKIPKEYFRAME = (4 * AV_TIME_BASE)};
enum {DISPQT_FFMPGVIDEOCALLBACK_VIDEODELAYCOUNT_MIDDLE = 3, DISPQT_FFMPGVIDEOCALLBACK_VIDEODELAYCOUNT_LARGE = 10, DISPQT_FFMPGVIDEOCALLBACK_VIDEODELAYCOUNT_SIGNIFICANT = 20};
enum {DISPQT_FFMPGVIDEOCALLBACK_VIDEODELAYFRAMEDROP_NONE = 0, DISPQT_FFMPGVIDEOCALLBACK_VIDEODELAYFRAMEDROP_LARGE = 1, DISPQT_FFMPGVIDEOCALLBACK_VIDEODELAYFRAMEDROP_DOUBLE = 2};
#define DISPQT_FFMPGVIDEOCALLBACK_VIDEOFRAME_INTERVAL_1FPS  AV_TIME_BASE // reference at calculating fps
#define DISPQT_FFMPGVIDEOCALLBACK_VIDEOFRAME_INTERVAL_5FPS  200000 // fps drop rate at speed-seek (or at manual speed up)
#define DISPQT_FFMPGVIDEOCALLBACK_VIDEOFRAME_INTERVAL_24FPS 41666  // significant delay divisor for hwtextures
#define DISPQT_FFMPGVIDEOCALLBACK_VIDEOFRAME_INTERVAL_33FPS 30000  // significant delay divisor for sw/pool frame buffers
#define DISPQT_WORKDEC_VIDEODELAY_FRAMEDROP_RESTORE_RETRY   4      // retry to restore pushing frames with original fps (after this keep reduced fps till seeking)

typedef struct mpxplay_dispqt_ffmpegvideo_worker_info_s{
	ffmpegvideo_callback_list_s *cblist_first, *cblist_last;
	dispqt_video_surface_info_s *video_surface_infos;
	MainWindow *main_window;
	void *mutexhnd_workerinfo;
	int nb_callbacks; // from cblist_first
	unsigned int video_scheduler_control, video_scheduler_status; // DISPQT_VIDEOSCHEDULER_CONTROL_
	unsigned int video_surface_refresh_request; // DISPQT_VIDEOSURFACE_REFRESHTYPE_
#ifdef DISPQT_VIDEO_SCHEDULER_USE_CONST_DECODER_THREAD
	unsigned int video_decoderthread_control; // DISPQT_VIDEOSCHEDULER_CONTROL_
#endif
	bool is_video_stream, is_videosurface_open, is_paused;
	bool is_videowall_enabled;
}mpxplay_dispqt_ffmpegvideo_worker_info_s;

class FFMpegVideoDecoderWorker : public QObject
{
Q_OBJECT
public:
	FFMpegVideoDecoderWorker(MainWindow *main_window = 0, dispqt_video_surface_info_s *video_surface_infos = 0);
	~FFMpegVideoDecoderWorker();
	bool videothread_ffmpeg_config_callback(unsigned int cfgcmd, mpxp_ptrsize_t cbk_func, mpxp_ptrsize_t passdata);
	void videothread_ffmpeg_callback_call(int globalpos_x, int globalpos_y, unsigned long command, mpxp_ptrsize_t arg1, mpxp_ptrsize_t arg2);
	bool decoderworker_video_scheduler_control(unsigned int control_req);
	void decoderworker_video_surface_refresh(unsigned int refresh_type); // DISPQT_VIDEOSURFACE_REFRESHTYPE_

private:
	void cb_queue_videostreamdecoderthread_set(ffmpegvideo_callback_list_s *cbelem, int streamtype_index);
	void cb_queue_videostreamdecoderthread_clear(ffmpegvideo_callback_list_s *cbelem, int streamtype_index);
	int  cb_queue_put_entry(struct mpxplay_dispqt_ffmpegvideo_worker_info_s *workinfos, mpxp_ptrsize_t cbk_func, mpxp_ptrsize_t passdata, bool insert_to_begin);
	int  cb_queue_del_entry(struct mpxplay_dispqt_ffmpegvideo_worker_info_s *workinfos, mpxp_ptrsize_t cbk_func, mpxp_ptrsize_t passdata);
	void cb_queue_elem_decoder_close(struct ffmpegvideo_callback_list_s *cbelem);
	void cb_queue_elem_clear(struct ffmpegvideo_callback_list_s *cbelem);
	void cb_queue_clear(struct mpxplay_dispqt_ffmpegvideo_worker_info_s *workinfos);

	int  videothread_videowall_search_windowitem(ffmpegvideo_callback_list_s *cbelem, int streamtypeindex, int globalpos_x, int globalpos_y, bool halve_win_width);
	int  decoderworker_video_load_next_frame(ffmpegvideo_callback_list_s *cbelem, bool *resetvideo);
	void decoderworker_video_reset(ffmpegvideo_callback_list_s *cbelem, int video_index);
	bool decoderworker_video_frame_scheduler(ffmpegvideo_callback_list_s *cbelem, int video_index, mpxp_int64_t timestamp_curr_ms);

	MainWindow *main_window;
	mpxplay_dispqt_ffmpegvideo_worker_info_s video_worker_infos;
	mpxp_thread_id_type videodworker_thread_id;                    // (constant) video frame scheduler thread id
#ifdef DISPQT_VIDEO_SCHEDULER_USE_CONST_DECODER_THREAD
	mpxp_thread_id_type videodecoder_thread_id;                    // constant decoder thread id
#endif
};

//-------------------------------------------------------------------------------------------------------------
extern bool mpxplay_dispqt_videotrans_crop_change_check(struct dispqt_video_source_info_s *video_source_infos, struct dispqt_video_surface_info_s *video_surface_infos);
extern bool mpxplay_dispqt_videotrans_autocrop_process(uint8_t *data_begin, const int data_linesize, const int data_format,
		const int video_width, const int video_height, const int data_elemsize,
		dispqt_video_source_info_s *video_source_infos, mpxp_bool_t *videooutsurface_clearpic);
extern void mpxplay_dispqt_videotrans_autocrop_reset(struct dispqt_video_source_info_s *video_source_infos);
extern void mpxplay_dispqt_videotrans_autocrop_clear(struct dispqt_video_source_info_s *video_source_infos);

extern int  mpxplay_dispqt_videotrans_ffmpeg_swsctx_init(struct dispqt_video_filter_info_s *video_filter_infos, AVFrame *input_video_frame, struct dispqt_video_filter_format_s *output_format);
extern void mpxplay_dispqt_videotrans_ffmpeg_swsctx_clean(struct dispqt_video_filter_info_s *video_filter_infos);
extern void mpxplay_dispqt_videotrans_ffmpeg_swsctx_close(struct dispqt_video_filter_info_s *video_filter_infos);
extern bool mpxplay_dispqt_videotrans_ffmpeg_swsctx_conv_frame(struct dispqt_video_filter_info_s *video_filter_infos, AVFrame *ivf, struct dispqt_video_filter_format_s *output_format);
extern bool mpxplay_dispqt_videotrans_ffmpeg_swsctx_pixfmt_conv(struct dispqt_video_filter_info_s *video_filter_infos, AVFrame *input_avframe, AVPixelFormat out_pixfmt);
extern int  mpxplay_dispqt_videotrans_videooutput_get_custom_ar_value(char *custom_str, int scale_value, int default_value);
extern unsigned long mpxplay_dispqt_videotrans_rotate_get_type(struct mmc_dispqt_config_s *gcfg, AVFrame *video_avframe);
extern bool mpxplay_dispqt_videotrans_videoframe_hw_rotate_check(struct dispqt_video_surface_info_s *video_surface_infos, AVFrame *video_avframe);
extern bool mpxplay_dispqt_videotrans_videooutput_surface_move_calculate(struct dispqt_video_source_info_s *video_source_infos, struct dispqt_video_surface_info_s *video_surface_infos,
	struct mmc_dispqt_config_s *gcfg, int widget_global_pos_x, int widget_global_pos_y, int move_x, int move_y);
extern bool mpxplay_dispqt_videotrans_videooutput_surface_zoom_calculate(struct dispqt_video_source_info_s *video_source_infos, struct dispqt_video_surface_info_s *video_surface_infos,
	struct mmc_dispqt_config_s *gcfg, int globalpos_x, int globalpos_y, int direction);
extern bool mpxplay_dispqt_videotrans_videooutput_surface_window_calculate(struct dispqt_video_source_info_s *video_source_infos, struct dispqt_video_surface_info_s *video_surface_infos,
	struct mmc_dispqt_config_s *gcfg);

class FFMpegVideoSoftwareTransform
{
public:
	FFMpegVideoSoftwareTransform(MainWindow *mainwindow = 0, dispqt_video_source_info_s *video_source_infos = 0, dispqt_video_surface_info_s *video_surface_infos = 0);
	~FFMpegVideoSoftwareTransform();

	void videowidget_ffmpeg_videoctx_clear(void);
	void videowidget_ffmpeg_videoctx_reconfig(void);
	void videowidget_ffmpeg_swsctx_close(void);

	void videowidget_ffmpeg_filtered_crop_update(bool check_autocrop);
	void videowidget_ffmpeg_filtered_trans_update(void);
	void videowidget_ffmpeg_filtered_eq_update(void);

private:
	int  videowidget_ffmpeg_videoctx_init(struct dispqt_video_filter_info_s *video_filter_infos);
	void videowidget_ffmpeg_videoctx_close(struct dispqt_video_filter_info_s *video_filter_infos);
	int  videowidget_ffmpeg_swsctx_init(struct dispqt_video_filter_info_s *video_filter_infos, AVFrame *input_video_frame, int output_width, int output_height, enum AVPixelFormat output_pixelformat);
	int  videowidget_ffmpeg_swsctx_get_sws_outformat(struct dispqt_video_filter_info_s *video_filter_infos, AVFrame *input_video_frame);
	bool videowidget_ffmpeg_swsctx_conv_frame(struct dispqt_video_filter_info_s *video_filter_infos);
	bool videowidget_ffmpeg_swsctx_check_swsframe_for_outsurface(struct dispqt_video_filter_info_s *video_filter_infos);
	void videowidget_ffmpeg_swsctx_close(struct dispqt_video_filter_info_s *video_filter_infos);
	void videowidget_ffmpeg_swsctx_clear(struct dispqt_video_filter_info_s *video_filter_infos);

	MainWindow *main_window;
	dispqt_video_source_info_s *video_source_infos;
	dispqt_video_surface_info_s *video_surface_infos;
	dispqt_video_filter_info_s video_filter_infos;
};

class FFMpegVideoWidget : public QWidget
{
Q_OBJECT
public:
	FFMpegVideoWidget(MainWindow *main_window = 0, QWidget *parent = 0);
	~FFMpegVideoWidget();
	void videowidget_fullscreen_set(mpxp_bool_t full);
	void videowidget_screen_clear(void);
	void videowidget_vmixer_set(unsigned int u_id, int value);
	bool videowidget_ffmpeg_config_callback(unsigned int cfgcmd, mpxp_ptrsize_t cbk_func, mpxp_ptrsize_t passdata);
	void videowidget_ffmpeg_callback_call(int globalpos_x, int globalpos_y, unsigned long command, mpxp_ptrsize_t arg1, mpxp_ptrsize_t arg2);
	bool videowidget_ffmpeg_schedulerthread_suspend(void);
	void videowidget_ffmpeg_schedulerthread_resume(void);

Q_SIGNALS:
	void signal_ffmpeg_swctx_resize(int window_width, int window_height, bool do_repaint);
	void signal_ffmpeg_swctx_move(int move_x, int move_y);
	void signal_ffmpeg_swctx_zoom(int globalpos_x, int globalpos_y, int direction);
	void signal_ffmpeg_filtered_trans_refresh(void);
	void signal_ffmpeg_filtered_eq_refresh(void);

public Q_SLOTS:
	void videowidget_ffmpeg_swctx_resize(int window_width, int window_height, bool do_repaint);
	void videowidget_ffmpeg_swctx_move(int move_x, int move_y);
	void videowidget_ffmpeg_swctx_zoom(int globalpos_x, int globalpos_y, int direction);
	void videowidget_ffmpeg_filtered_trans_refresh(void);
	void videowidget_ffmpeg_filtered_eq_refresh(void);
	void videowidget_ffmpeg_frame_display(int video_index, unsigned int flags, AVFrame *videoout_frame, ffmpegvideo_subtitle_info_s *subtitle_infos, unsigned int refresh_type);

protected:
	void resizeEvent(QResizeEvent *e);
	void moveEvent(QMoveEvent *event);
	void paintEvent(QPaintEvent *event);
	QPaintEngine* paintEngine() const;

private:
	void videowidget_renderer_init(void);
	void videowidget_renderer_close(void);
	void videowidget_fullscreen_display_select(void);

	void videowidget_ffmpeg_filtered_surface_update(bool high_priority);

	bool videowidget_ffmpeg_handle_refresh(unsigned int refresh_type, bool doRepaint);

	MainWindow *main_window;
	QWidget *parent_widget;
	MMCDispQtVideoRendererBase *video_renderer;
	FFMpegVideoSoftwareTransform *video_sw_transform;
	FFMpegVideoDecoderWorker *video_decoder_worker;
	dispqt_video_source_info_s video_source_infos;
	dispqt_video_surface_info_s video_surface_infos;
	QMutex mutex_widget;
};

#endif // MPXPLAY_LINK_ORIGINAL_FFMPEG

class DispQtVideoPlayer : public QWidget
{
Q_OBJECT
public:
enum {VideoCtrlValue_FullScreen = 0, VideoCtrlValue_VideoWallAvailable, VideoCtrlValue_VideoWallEnabled, VideoCtrlValue_VideoWallARtype, VideoCtrlValue_Height, VideoCtrlValue_Speed};
	DispQtVideoPlayer(MainWindow *main_window = 0, QWidget *parent = 0);
	~DispQtVideoPlayer();
	void video_mediaplayer_open(bool lock_qmedia);
	void video_mediaplayer_close(void);
	void set_focus(void) { if(this->video_widget_context) this->video_widget_context->setFocus(Qt::MouseFocusReason); }
	void video_request_open(void *handle_ptr, char *utf8_filename);
	bool video_wait_for_open(void);
	void video_request_close(void *handle_ptr);
	bool video_wait_for_close(void);
	bool video_is_fullscreen(void) { return ((this->video_widget_context)? this->video_widget_context->isFullScreen() : false); }
	qint64 video_tell_ms(void);
	qint64 video_duration_ms(void);
	QWidget *video_get_widgetptr(void) { return this->video_widget_context; }
	int  video_get_value(unsigned int ctrl);
	void video_mouse_cursor_show(bool timed);
	void video_mouse_cursor_forbid_hide(bool forbid);
	void video_widget_init(void);
	void video_widget_control(unsigned long mainwin_control);
	//QString video_media_name(void) { return this->media_name; }
#ifdef MPXPLAY_LINK_ORIGINAL_FFMPEG
	int video_ffmpeg_configcallback_create(unsigned int cfgcmd, mpxp_ptrsize_t cbk_func, mpxp_ptrsize_t passdata);
	bool video_ffmpeg_schedulerthread_suspend(void);
	void video_ffmpeg_schedulerthread_resume(void);
	void video_ffmpeg_framedisplay_wrapper(int video_index, unsigned int flags, void *videoout_frame, void *subtitle_infos, unsigned int refresh_type);
	DispQtVideoFrameFilter *video_frame_filter_transform_process;
#endif
	DispQtVideoFrameFilter *video_frame_filter_eq_process;

Q_SIGNALS:
	void signal_video_open(void);
	void signal_video_close(void);
	void signal_video_play(unsigned int playctrlflags);
	void signal_video_pause(void);
	void signal_video_switch_play(void);
	void signal_video_seek_ms(qint64 pos_ms);
	void signal_video_switch_fullscreen(void);
	void signal_video_change_fullscreen(bool delayed);
	void signal_video_set_fullscreen(bool fs);
	void signal_video_apply_fullscreen(bool fs); // 2nd step of switch_fullscreen
	void signal_video_check_windows(void);
	void signal_video_apply_windows(void);       // 3rd step of switch_fullscreen
	void signal_video_event_stop(void);
	void signal_video_set_speed(int speed1000);
	void signal_audio_set_volume(int vol);
	void signal_video_set_value(unsigned int ctrl, int val);
#ifdef MPXPLAY_LINK_ORIGINAL_FFMPEG
	void signal_video_surface_resize_refresh(void);
	void signal_video_surface_filtered_trans_refresh(void);
	void signal_video_surface_filtered_eq_refresh(void);
	void signal_ffmpeg_configcallback_nonblock(unsigned int cfgcmd, mpxp_ptrsize_t cbk_func, mpxp_ptrsize_t passdata);
	void signal_ffmpeg_config_callback(unsigned int cfgcmd, mpxp_ptrsize_t cbk_func, mpxp_ptrsize_t passdata);
	void signal_ffmpeg_callback_call(int globalpos_x, int globalpos_y, unsigned long command, mpxp_ptrsize_t arg1, mpxp_ptrsize_t arg2);
#endif

private Q_SLOTS:
	void video_open(void);
	void video_close(void);
	void video_play(unsigned int playctrlflags);
	void video_pause(void);
	void video_switch_play(void) { if(this->is_playing) this->video_pause(); else this->video_play(false); }
	void video_stop(void *handle_ptr, bool close_media);
	void video_seek_ms(qint64 pos_ms);
	void video_switch_fullscreen(void);
	void video_change_fullscreen_do(void);
	void video_change_fullscreen(bool delayed);
	void video_set_fullscreen(bool fs);
	void video_apply_fullscreen(bool fs);
	void video_check_windows(void);
	void video_apply_windows(void);
	void video_handle_event_stop(void);
	void video_set_speed(int speed1000);
	void audio_set_volume(int vol);
	void video_set_value(unsigned int ctrl, int val);
#ifdef MPXPLAY_LINK_ORIGINAL_FFMPEG
	void video_surface_clear(void);
	void video_surface_resize_refresh(void);
	void video_surface_filtered_trans_refresh(void);
	void video_surface_filtered_eq_refresh(void);
	void video_ffmpeg_configcallback_wrapper(unsigned int cfgcmd, mpxp_ptrsize_t cbk_func, mpxp_ptrsize_t passdata);
	void video_ffmpeg_config_callback(unsigned int cfgcmd, mpxp_ptrsize_t cbk_func, mpxp_ptrsize_t passdata);
	void video_ffmpeg_callback_call(int globalpos_x, int globalpos_y, unsigned long command, mpxp_ptrsize_t arg1, mpxp_ptrsize_t arg2);
#endif

#ifdef MPXPLAY_LINK_QTMEDIA
	void status_changed(QMediaPlayer::MediaStatus status);
	void display_error_message(QMediaPlayer::Error);
#endif

private:
#ifdef MPXPLAY_LINK_QTMEDIA
	void video_cursor_select(QMediaPlayer::MediaStatus status);
#endif

	MainWindow *main_window;
	QWidget *parent_widget;
	QHBoxLayout *video_layout;
	QString media_name;
#ifdef MPXPLAY_LINK_QTMEDIA
	QMediaPlayer *qt_media_player;
	QUrl media_url;
	QMediaContent media_content;
#endif
	DispQtVideoEventFilter *video_event_filter;
	QWidget *video_widget_context;
	Qt::WindowFlags video_wdg_nonfullscreen_flags;
	bool is_video_show, is_video_open, is_wait_for_open, is_playing;
	bool is_wait_for_close, is_video_closed, is_videowall_available, is_videowall_enabled;
	void *ptr_handle_curr, *ptr_handle_new, *ptr_handle_close; // for close identification
	QMutex mutex_player, mutex_qmedia;
	QTimer timer_fullscreen_change;
};

#ifdef MPXPLAY_LINK_ORIGINAL_FFMPEG
// video_workdec.cpp
extern void mpxplay_dispqt_video_decoder_worker_close(struct ffmpegvideo_callback_list_s *cbelem);
extern void mpxplay_dispqt_video_decoder_worker_process(struct ffmpegvideo_callback_list_s *cbelem, unsigned int *sleep_time);
#if defined(DISPQT_VIDEO_SCHEDULER_USE_DECODER_THREAD) || defined(DISPQT_VIDEO_SCHEDULER_USE_CONST_DECODER_THREAD)
#if defined(PDS_THREADS_POSIX_THREAD)
extern void *mpxplay_dispqt_video_decoder_worker_thread(void *decoder_data);
#else
extern unsigned int mpxplay_dispqt_video_decoder_worker_thread(void *decoder_data);
#endif
#endif
// video_widget.cpp
extern mpxp_bool_t mpxplay_dispqt_videowidget_direct_frame_display(dispqt_video_surface_info_s *video_surface_infos, unsigned int flags, AVFrame *videoout_frame, ffmpegvideo_subtitle_info_s *subtitle_infos, unsigned int refresh_type);
#endif

#endif // MOC_VIDEO_QT_H
