//**************************************************************************
//*                     This file is part of the                           *
//*                MMC - Mpxplay Multimedia Commander                      *
//*                   The source code of MMC is                            *
//*        (C) copyright 1998-2022 by PDSoft (Attila Padar)                *
//*                http://mpxplay.sourceforge.net                          *
//*                  email: mpxplay@freemail.hu                            *
//**************************************************************************
//*  This program is distributed in the hope that it will be useful,       *
//*  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
//*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                  *
//*  Please contact with the author (with me) if you want to use           *
//*  or modify this source.                                                *
//**************************************************************************
//function: Direct3D 11 render output definitions

#ifndef VIDEO_RENDER_DX11_H
#define VIDEO_RENDER_DX11_H

#define COBJMACROS
#include <initguid.h>
#include <d3d11.h>
#include <dxgi1_2.h>
#include <d3dcompiler.h>
#include "video_render_comm.h"

#define DISPQT_EVR_USE_10BIT_OUTPUT    1
#define DISPQT_EVR_SWAPCHAN_BUFFERS    2
#define DISPQT_EVR_BUFFERS_TO_CLEAR    (DISPQT_EVR_SWAPCHAN_BUFFERS + 1)
#define DISPQT_EVR_DEINTERLACE_REF_FRAMES 3
#define DISPQT_EVR_HWDEC_POOL_SIZE_MAX 64

#define DISPQT_RENDER_D3D11_VERTEX_POSITION_SCALE DISPQT_RENDER_VERTEX_POSITION_BASE_SCALE

enum {DISPQT_EVR_PIXSHADERCONST_COLORMIXER = 0, DISPQT_EVR_PIXSHADERCONST_YUVTORGB, DISPQT_EVR_PIXSHADERCONST_RUNTIME, DISPQT_EVR_PIXSHADERCONST_NUM};

typedef struct dispqt_evr_d3d_api_s{
	HMODULE        d3dcompiler_dll_hnd;             // handler for D3DCOMPILER_4x.DLL
	pD3DCompile    d3d_shader_compiler_func;        // function pointer to D3DCompile
}dispqt_evr_d3d_api_s;

typedef struct dispqt_evr_deinterlace_data_s{
	ID3D11VideoProcessorEnumerator *d3d_deinterlace_enumerator;    // video processor enumerator for deinterlace
	ID3D11VideoProcessor           *d3d_deinterlace_processor;     // video processor handler for deinterlace
	ID3D11Texture2D                *d3d_deinterlace_intextures[DISPQT_EVR_DEINTERLACE_REF_FRAMES]; // input reference textures for deinterlace
	ID3D11VideoProcessorInputView  *d3d_deinterlace_inviews[DISPQT_EVR_DEINTERLACE_REF_FRAMES];    // views for input textures
	ID3D11VideoProcessorOutputView *d3d_deinterlace_outview;       // output view for deinterlace
	ID3D11Texture2D                *d3d_deinterlace_outtexture[DISPQT_EVR_NB_MAX_PLANES];     // output texture for deinterlace
	ID3D11ShaderResourceView       *d3d_deinterlace_out_shaderview[DISPQT_EVR_NB_MAX_PLANES]; // shader resource view of output texture
	mpxp_uint32_t                   d3d_deinterlace_frame_counter; // for input reference texture decisions
	mpxp_uint32_t                   d3d_deinterlace_frdup_pass;    // pass (step) of duplicated frame rate (passing the same input texture to deinterlace with inverted field flag)
	mpxp_uint32_t                   d3d_deinterlace_videoplayer_control; // used selected_videoplayer_control
}dispqt_evr_deinterlace_data_s;

typedef struct dispqt_evr_input_texture_data_s{
	unsigned int               texture_id;                   // DISPQT_EVR_INPUTTEXUREID_
	int                        input_width, input_height;    // resolution of selected input texture (d3d_input_texture_2d, hwdec or pool)
	int                        video_width, video_height;    // reference video resolution, used to create d3d_input_texture_2d (without alignment)
	int                        texture_width, texture_height;// resolution of the created d3d_input_texture_2d (with alignment at video frames) (at subtitles: video and texture resolutions are always equal)
	int                        av_pixelformat;               // pixel format of input video (can be AV_PIX_FMT_D3D11 or match with avframe pixfmt)
	AVColorTransferCharacteristic av_colortrc;               // color transfer characteristic of the input video
	enum AVColorRange          av_colorrange;                // color range of input video (MPEG/FULL)
	AVColorSpace               av_colorspace;                // color space of input video
	AVColorPrimaries           av_colorprimaries;            // color primaries of the input video
	ID3D11InputLayout         *d3d_vertex_input_layout;      // input (argument) layout handler of vertex shader // note: currently vertex shader and layout are same at all textures
	ID3D11VertexShader        *d3d_vertex_shader_hnd;        // handler of compiled vertex shader code           // because both of them uses flat/constant vertices (later vertex method of video frame will be different)
	ID3D11Buffer              *d3d_vertex_buffer;            // transformation data buffer of vertex shader
	int                        vertex_buffer_elems;          // number of triangle points (24 or 6)
	ID3D11PixelShader         *d3d_pixel_shader_hnd;         // handler of compiled pixel shader code
	ID3D11Buffer              *d3d_pixelshader_constbuffs[DISPQT_EVR_PIXSHADERCONST_NUM];// pixel shader constant buffers
	ID3D11ShaderResourceView  *d3d_input_shaderview_selector[DISPQT_EVR_NB_MAX_PLANES];// pointer to the selected shader resource views (hwdec, pool or deinterlace output)
	ID3D11Texture2D           *d3d_input_texture_2d[DISPQT_EVR_NB_MAX_PLANES];         // input textures (one for standard dxgi format, or multiply textures for custom planes)
	ID3D11ShaderResourceView  *d3d_input_shader_resource_views[DISPQT_EVR_NB_MAX_PLANES];// shader resource views for d3d_input_texture_2d (only)
	D3D11_MAPPED_SUBRESOURCE   d3d_texture_mappedResource[DISPQT_EVR_NB_MAX_PLANES]; // memory/texture infos from d3d_device_context->Map()
	struct dispqt_evr_format_desc_s *pixel_format_infos;     // informations of selected input pixelformat
	struct dispqt_evr_format_desc_s custom_pixel_format_info;// informations of a non standard/base texture format
	struct dispqt_evr_input_viewport_s texture_crop;         // last set texture crop (input of vertex)
	struct dispqt_evr_input_viewport_s texture_viewport;     // last set viewport values (output rectangle)
	struct dispqt_evr_deinterlace_data_s deinterlace_datas;  // datas related to the deinterlacing
}dispqt_evr_input_texture_data_s;

typedef struct dispqt_render_evr_hwdec_data_s{
	ID3D11Texture2D       *hwdec_reference_texture_2d;   // pointer to the texture array created in FFmpeg (reference for the shader resource views: if it changes, clear the views)
	unsigned int           hwdec_tex_arraysize;          // reference ArraySize of texture
	int                    hwdec_tex_width, hwdec_tex_height; // real resolution of hwdec input texture
	DXGI_FORMAT            hwdec_tex_format;
	ID3D11ShaderResourceView  *hwdec_shader_resource_views[DISPQT_EVR_HWDEC_POOL_SIZE_MAX][DISPQT_EVR_NB_MAX_PLANES]; // shader resource views for the hwdec texture array
}dispqt_render_evr_hwdec_data_s;

typedef struct dispqt_render_evr_textdown_data_s{
	ID3D11Texture2D    *d3d_texture_video_download;     // used to copy video texture from gpu to main memory (for autocrop)
	int down_tex_width, down_tex_height;                // rectangles of the allocated texture
	DXGI_FORMAT down_text_format;                       // dxgi format of the allocated texture
	mpxp_uint64_t last_process_time_ms;                 // to gain the autocrop processing (>=50fps can block the GPU)
}dispqt_render_evr_textdown_data_s;

typedef struct dispqt_render_evr_data_s{
	HWND                   parent_window_handler;
	ID3D11Device           *d3d_device;
	ID3D11DeviceContext    *d3d_device_context;
	ID3D11VideoDevice      *d3d_video_device;
	ID3D11VideoContext     *d3d_video_context;
	ID3D11BlendState       *d3d_blend_state;
	D3D_FEATURE_LEVEL      d3d_feature_level;
	IDXGIFactory           *dxgi_factory1;
	IDXGIFactory2          *dxgi_factory2;
	IDXGISwapChain         *swap_chain_sdr1;
	IDXGISwapChain1        *swap_chain_sdr2;
	DXGI_FORMAT            swapchain_format;
	mpxp_uint32_t          swapchain_width, swapchain_height;
	ID3D11RenderTargetView *d3d_render_target_view;
	mpxp_uint32_t          clear_counter;
	int                    subtitle_rendermode;
	mpxp_bool_t            update_vmixer_data;
	mpxp_int32_t           vmixer_values[DISPQT_VIDEO_VMIXERTYPE_MAX];
	struct dispqt_evr_d3d_api_s d3d_api_funcs;
	struct dispqt_render_evr_hwdec_data_s hwdec_datas;
	struct dispqt_render_evr_dynamic_hdr_data_s dynamic_hdr_datas;
	struct dispqt_render_evr_textdown_data_s textdown_datas;
	struct dispqt_evr_input_texture_data_s input_texture_datas[DISPQT_EVR_INPUTTEXUREID_NUM];
	struct dispqt_render_poolbufelem_s decoder_pool_datas[DISPQT_RENDER_POOLBUF_SIZE_MAX];
}dispqt_render_evr_data_s;

#if (__GNUC__ < 9) // FIXME: maybe not exact decision
typedef enum D3D11_VIDEO_PROCESSOR_FORMAT_SUPPORT
{
    D3D11_VIDEO_PROCESSOR_FORMAT_SUPPORT_INPUT = 0x00000001,
    D3D11_VIDEO_PROCESSOR_FORMAT_SUPPORT_OUTPUT = 0x00000002,
} D3D11_VIDEO_PROCESSOR_FORMAT_SUPPORT;
#endif

// ====================================================================================================================
// supported color formats and their attributes (sorted by native-support fall-through)

static struct dispqt_evr_format_desc_s dispqt_evr_supported_pixel_formats[] = { // TODO: check other unique pixel formats, not handled by dispqt_evr_input_select_color_format() generally
 { AV_PIX_FMT_BGR565LE,   DXGI_FORMAT_B5G6R5_UNORM,        5, 0, 1, 0, 0, 1, { DXGI_FORMAT_B5G6R5_UNORM } },
 { AV_PIX_FMT_BGR0,       DXGI_FORMAT_B8G8R8X8_UNORM,      8, 0, 1, 0, 0, 1, { DXGI_FORMAT_B8G8R8X8_UNORM } },
 { AV_PIX_FMT_RGBA,       DXGI_FORMAT_R8G8B8A8_UNORM,      8, 0, 1, 0, 0, 1, { DXGI_FORMAT_R8G8B8A8_UNORM } },
 { AV_PIX_FMT_BGRA,       DXGI_FORMAT_B8G8R8A8_UNORM,      8, 0, 1, 0, 0, 1, { DXGI_FORMAT_B8G8R8A8_UNORM } },
 { AV_PIX_FMT_NV24,       DXGI_FORMAT_UNKNOWN,             8, 0, 0, 0, 0, 2, { DXGI_FORMAT_R8_UNORM, DXGI_FORMAT_R8G8_UNORM } }, // Y, U and V sizes are equal
 { AV_PIX_FMT_NV42,       DXGI_FORMAT_UNKNOWN,             8, 0, 0, 0, 0, 2, { DXGI_FORMAT_R8_UNORM, DXGI_FORMAT_R8G8_UNORM } }, // Y, U and V sizes are equal
 { AV_PIX_FMT_NV12,       DXGI_FORMAT_NV12,                8, 0, 0, 1, 1, 2, { DXGI_FORMAT_R8_UNORM, DXGI_FORMAT_R8G8_UNORM } }, // if NV12 works, stop the 8 bit search (pixfmt replacement) here
 { AV_PIX_FMT_X2BGR10 ,   DXGI_FORMAT_R10G10B10A2_UNORM,  10, 0, 1, 0, 0, 1, { DXGI_FORMAT_R10G10B10A2_UNORM } },
 { AV_PIX_FMT_RGBAF16LE,  DXGI_FORMAT_R16G16B16A16_FLOAT, 16, 0, 1, 0, 0, 1, { DXGI_FORMAT_R16G16B16A16_FLOAT } },
 { AV_PIX_FMT_RGBA64LE,   DXGI_FORMAT_R16G16B16A16_UNORM, 16, 0, 1, 0, 0, 1, { DXGI_FORMAT_R16G16B16A16_UNORM } },
 { AV_PIX_FMT_Y210LE,     DXGI_FORMAT_Y210,               10, 0, 0, 1, 0, 1, { DXGI_FORMAT_R16G16B16A16_UNORM } },
 { AV_PIX_FMT_P016LE,     DXGI_FORMAT_P016,               16, 0, 0, 1, 1, 2, { DXGI_FORMAT_R16_UNORM, DXGI_FORMAT_R16G16_UNORM } },
 { AV_PIX_FMT_P010LE,     DXGI_FORMAT_P010,               10, 0, 0, 1, 1, 2, { DXGI_FORMAT_R16_UNORM, DXGI_FORMAT_R16G16_UNORM } },
 { AV_PIX_FMT_YUYV422,    DXGI_FORMAT_YUY2,                8, 0, 0, 1, 1, 1, { DXGI_FORMAT_R8G8B8A8_UNORM } },
 { AV_PIX_FMT_NV12,       DXGI_FORMAT_NV12,                8, 0, 0, 1, 1, 2, { DXGI_FORMAT_R8_UNORM, DXGI_FORMAT_R8G8_UNORM } },
 { AV_PIX_FMT_NV21,       DXGI_FORMAT_NV12,                8, 0, 0, 1, 1, 2, { DXGI_FORMAT_R8_UNORM, DXGI_FORMAT_R8G8_UNORM } },
 { AV_PIX_FMT_D3D11,      DXGI_FORMAT_UNKNOWN,             0, 1, 0, 0, 0, 0, { } },
 { AV_PIX_FMT_NONE,       DXGI_FORMAT_UNKNOWN,             0, 0, 0, 0, 0, 0, {} }
};

#endif // VIDEO_RENDER_DX11_H
