# ****************************************************************************
# `zip.mak' - Makefile to create ZIP archives for distribution
#   Written by Robert Riebisch
#   Modified for Info-ZIP Zip by Michal H. Tyc
# ****************************************************************************

# some basic error checking
!if !$d(AR) || !$d(ARFLAGS) || !$d(ARNODIRS) || !$d(ARSUBDIRS) || !$d(PROJECT)
  !error Don't call this Makefile directly!
!endif

# where to put ZIP files
.path.zip = ..

# distribution archives
zip: $(PROJECT)b.zip $(PROJECT)s.zip

# `Binaries + Manual' archive for distribution
$(PROJECT)b.zip:
  -cd ..
  -if exist $@ del $@
  -$(AR) $(ARFLAGS) $(ARNODIRS) $@ *.*
  -cd source

# `Source code' archive for distribution
$(PROJECT)s.zip:
  -cd ..
  -if exist $@ del $@
  -$(AR) $(ARFLAGS) $(ARSUBDIRS) $@ \
     file_id.diz legal.txt $(PROJECT).url source\*.*
  -cd source

# --- for internal use ---
backup mirror: $(PROJECT)m.zip

$(PROJECT)m.zip:
  -cd ..
  -if exist $@ del $@
  -$(AR) $(ARFLAGS) $(ARSUBDIRS) $@ *.*
  -cd source
