;	Copyright 1993-2022, Jerome Shidel.
;
;	This project and related files are subject to the terms of the Mozilla
; Public License, v. 2.0. If a copy of the MPL was not distributed with this
; file, You can obtain one at http://mozilla.org/MPL/2.0/.
;
; v2.00 - Mixer portion ported from Ancient Turbo Pascal Version to NASM

%imacro MIXER_CALL 1
	%ifndef SBPMixer_Required
		%define SBPMixer_Required
	%endif
	CALL %1
%endmacro

%define MIXER_RET  RET

%imacro MIXER_GetVersion 0 ; AX = version
      mov  ax, 0x00
      MIXER_CALL SBPMixer
%endmacro

%imacro MIXER_GetBasePort 0 ; AX = port
      mov  ax, 0x01
      MIXER_CALL SBPMixer
%endmacro

%imacro MIXER_GetMasterVolume 0 ; AH=Left, AL=Right
      mov  ax, 0x10
      MIXER_CALL SBPMixer
%endmacro

%imacro MIXER_GetVoiceVolume 0 ; AH=Left, AL=Right
      mov  ax, 0x11
      MIXER_CALL SBPMixer
%endmacro

%imacro MIXER_GetFMVolume 0 ; AH=Left, AL=Right
      mov  ax, 0x12
      MIXER_CALL SBPMixer
%endmacro

%imacro MIXER_GetCDVolume 0 ; AH=Left, AL=Right
      mov  ax, 0x13
      MIXER_CALL SBPMixer
%endmacro

%imacro MIXER_GetMicVolume 0 ; AH=undefined, AL=Value
      mov  ax, 0x14
      MIXER_CALL SBPMixer
%endmacro

%imacro MIXER_GetFMChannel 0 ; AH=undefined, AL=Value
      mov  ax, 0x15
      MIXER_CALL SBPMixer
%endmacro

%imacro MIXER_GetStereo 0 ; AH=undefined, AL=True/False
      mov  ax, 0x16
      MIXER_CALL SBPMixer
%endmacro

%imacro MIXER_GetLineVolume 0 ; AH=Left, AL=Right
      mov  ax, 0x17
      MIXER_CALL SBPMixer
%endmacro

%imacro MIXER_GetADCSource 0 ; AH=undefined, AL=Value
      mov  ax, 0x18
      MIXER_CALL SBPMixer
%endmacro

%imacro MIXER_GetADCFilter 0 ; AH=undefined, AL=True/False
      mov  ax, 0x19
      MIXER_CALL SBPMixer
%endmacro

%imacro MIXER_GetANFIFilter 0 ; AH=undefined, AL=True/False
      mov  ax, 0x1A
      MIXER_CALL SBPMixer
%endmacro

%imacro MIXER_GetDNFIFilter 0 ; AH=undefined, AL=True/False
      mov  ax, 0x1B
      MIXER_CALL SBPMixer
%endmacro

%imacro MIXER_SetBasePort 1 ; Port : word
      mov  bx, %1
      mov  ax, 0x02
      MIXER_CALL SBPMixer
%endmacro

%imacro MIXER_Reset 0
      mov  ax, 0x03
      MIXER_CALL SBPMixer
%endmacro

%imacro MIXER_SetMasterVolume 2 ; Left, Right : byte
      mov  bh,, %1
      mov  bl, %2
      mov  ax, 0x04
      MIXER_CALL SBPMixer
%endmacro

%imacro MIXER_SetVoiceVolume 2 ; Left, Right : byte
      mov  bh, %1
      mov  bl, %2
      mov  ax, 0x05
      MIXER_CALL SBPMixer
%endmacro

%imacro MIXER_SetFMVolume 2 ; Left, Right : byte
      mov  bh, %1
      mov  bl, %2
      mov  ax, 0x06
      MIXER_CALL SBPMixer
%endmacro

%imacro MIXER_SetCDVolume 2 ; Left, Right : byte
      mov  bh, %1
      mov  bl, %2
      mov  ax, 0x07
      MIXER_CALL SBPMixer
%endmacro

%imacro MIXER_SetMICVolume 1 ; Volume : byte
      mov  bh, %1
      mov  bl, bh
      mov  ax, 0x08
      MIXER_CALL SBPMixer
%endmacro

%imacro MIXER_SetFMChannel 1 ; Channel : byte =
;      0 : No Steering
;      1 : Steer to Left
;      2 : Steer to Right
;      3 : MUTE
      xor  bh, bh
      mov  bl, %1
      mov  ax, 0x09
      MIXER_CALL SBPMixer
%endmacro

%imacro MIXER_SetStereo 1 ; State : boolean = Stereo/Mono
      xor  bh, bh
      mov  bl, %1
      mov  ax, 0x0A
      MIXER_CALL SBPMixer
%endmacro

%imacro MIXER_SetLineVolume 2 ; Left, Right : byte
      mov  bh, %1
      mov  bl, %2
      mov  ax, 0x0B
      MIXER_CALL SBPMixer
%endmacro

%imacro MIXER_SetADCSource 1 ; Source : byte =
;      0 : MIC
;      1 : CD Rom
;      2 : Reserved
;      3 : Line
      xor  bh, bh
      mov  bl, %1
      mov  ax, 0x0C
      MIXER_CALL SBPMixer
%endmacro

%imacro MIXER_SetADCFilter 1 ; State : boolean = High/Low
      xor  bh, bh
      mov  bl, %1
      mov  ax, 0x0D
      MIXER_CALL SBPMixer
%endmacro

%imacro MIXER_SetANFIFilter 1 ; State : boolean = On/Off
      xor  bh, bh
      mov  bl, %1
      mov  ax, 0x0E
      MIXER_CALL SBPMixer
%endmacro

%imacro MIXER_SetDNFIFilter 1 ; State : boolean = On/Off
      xor  bh, bh
      mov  bl, %1
      mov  ax, 0x0F
      MIXER_CALL SBPMixer
%endmacro

; Language extensions

%imacro retz 0
        jnz     %%Skip
        ret
    %%Skip:
%endmacro

%imacro retnz 0
        jz      %%Skip
        ret
    %%Skip:
%endmacro

%imacro rete 0
        jne     %%Skip
        ret
    %%Skip:
%endmacro

%imacro retc 0
        jnc     %%Skip
        ret
    %%Skip:
%endmacro

%imacro pushall 0
	pushf
	push	    ax
	push 	    bx
	push	    cx
	push	    dx
	push	    si
	push	    di
	push	    es
	push	    ds
	push        bp
%endmacro

%imacro popall 0
	pop         bp
	pop 	    ds
	pop		    es
	pop		    di
	pop		    si
	pop		    dx
	pop		    cx
	pop		    bx
	pop		    ax
	popf
%endmacro

%imacro pushm 0-*
    %ifidni %0, 0
        pushall
    %else
        %rep  %0
            push    %1
        %rotate 1
        %endrep
    %endif
%endmacro

%imacro popm 0-*
    %ifidni %0, 0
        popall
    %else
        %rep %0
        %rotate -1
            pop     %1
        %endrep
    %endif
%endmacro

%imacro DefReg 2-*
    %ifidni %0, 2
    	%ifnidni %1, %2
    		mov	%2, %1
    	%endif
    %elifidni %0, 4
   		%ifidni %1, %4
	   		push %3
    	    mov  %2, %1
			pop  %4
		%else
			%ifnidni %1, %2
				mov     %2, %1
			%endif
			%ifnidni %3, %4
				mov     %4, %3
			%endif
		%endif
	%else
        %rep  %0 / 2
			%ifnidni %1, %2
	            ; %warning push %1 for %2
				push     %1
			%endif
            %rotate 2
        %endrep
        %rep %0 / 2
	        %rotate -2
			%ifnidni %1, %2
	            ; %warning pop %2 was %1
				pop     %2
			%endif
        %endrep
	%endif
%endmacro

; General function call macros and defines

; DOS Program Prefix Segment Offset Definitions
; byte, CP/M exit INT 20h
%idefine PSP_INT20      0x00

; word, Segment of the first byte beyond the program
%idefine PSP_MEMTOP     0x02

; 5 bytes, Far call to DOS Function Dispatcher
%idefine PSP_DOSCALL    0x05

; dword, Terminate address for parent program
%idefine PSP_TERMINATE  0x0A

; dword, Control-Break address for parent program
%idefine PSP_BREAK      0x0E

; dword, Critical error address for parent program
%idefine PSP_ERROR      0x12

; word, Parent program PSP Segment
%idefine PSP_PARENT     0x16

; word, Environment Segment
%idefine PSP_ENV        0x2c

; byte, Number of bytes in command line
%idefine PSP_CMDLEN     0x80

; command line, ends in 0x0d
%idefine PSP_CMDLN      0x81

%imacro Terminate 0-1 0
    mov         al, %1
    jmp         Terminate_Proc
%endmacro

%imacro IdleCPU 0
	%ifndef IdleCPU_Required
		%define IdleCPU_Required
	%endif
    call  IdleCPU_Proc
%endmacro

%imacro StdOut 0-*
    %ifnidni %0, 0
    	mov	ah, 0x02
        %rep  %0
        	DefReg %1, dl
            int    0x21
        %rotate 1
        %endrep
    %endif
%endmacro

%imacro StdOutStr 1
	%ifndef StdOutStr_Required
		%define StdOutStr_Required
	%endif
	push	si
   	DefReg  %1, si
    call    StdOutStr_Proc
    pop		si
%endmacro

%imacro StdOutChar 1
	pushm	ax, dx
	StdOut	%1
	popm	ax, dx
%endmacro

%imacro StdOutCRLF 0
	%ifndef StdOutCRLF_Required
		%define StdOutCRLF_Required
	%endif
    call    StdOutCRLF_Proc
%endmacro

%imacro StdOutHexByte 1
	%ifndef StdOutHexByte_Required
		%define StdOutHexByte_Required
	%endif
	push	ax
   	DefReg  %1, al
    call    StdOutHexByte_Proc
    pop		ax
%endmacro

%imacro StdOutHexWord 1
	%ifndef StdOutHexWord_Required
		%define StdOutHexWord_Required
	%endif
	push	ax
   	DefReg  %1, ax
    call    StdOutHexWord_Proc
    pop		ax
%endmacro

%imacro StdOutIntByte 1
	%ifndef StdOutIntWord_Required
		%define StdOutIntWord_Required
	%endif
	push	ax
   	DefReg  %1, al
	xor		ah, ah
    call    StdOutIntWord_Proc
    pop		ax
%endmacro

%imacro StdOutIntWord 1
	%ifndef StdOutIntWord_Required
		%define StdOutIntWord_Required
	%endif
	push	ax
   	DefReg  %1, ax
    call    StdOutIntWord_Proc
    pop		ax
%endmacro

%imacro GetEnvStr 1
; %1 is Offset of Search String, returns DS:SI points to data
; if not found then carry flag is set and DS:SI points to null at the end of
; the environment table.
	%ifndef GetEnvStr_Required
		%define GetEnvStr_Required
	%endif
	push	bx
   	DefReg  %1, bx
    call    GetEnvStr_Proc
    pop		bx
%endmacro


%imacro ParseStr 2
; CS:%1	Pointer to sub-string handler
; DS:%2 Pointer to string to processes
; CF is set if error occurred
	%ifndef ParseStr_Required
		%define ParseStr_Required
	%endif
	pushm   di, si
	DefReg  %1, di, %2, si
    call    ParseStr_Proc
    popm	di, si
%endmacro

%imacro StdOutLenStr 2
; %1	Length of String
; DS:%2 Pointer to string to output
	%ifndef StdOutLenStr_Required
		%define StdOutLenStr_Required
	%endif
	pushm   cx, si
	DefReg  %1, cx, %2, si
    call    StdOutLenStr_Proc
    popm    cx, si
%endmacro

%imacro LowerCaseChar 1
		cmp		%1, 0x41
		jb		.NoChange
		cmp		%1, 0x5a
		ja		.NoChange
		add		%1, 0x20
	.NoChange:
%endmacro

%imacro UpperCaseChar 1
		cmp		%1, 0x61
		jb		.NoChange
		cmp		%1, 0x7a
		ja		.NoChange
		sub		%1, 0x20
	.NoChange:
%endmacro

%imacro LenStrToWord 2
; %1	Length of String
; DS:%2 Pointer to string to convert
; Return AX = value, CF if error
	%ifndef LenStrToWord_Required
		%define LenStrToWord_Required
		%define LenStrToWordHex_Required
	%endif
	pushm   cx, di
	DefReg  %1, cx, %2, di
    call    LenStrToWord_Proc
    popm    cx, di
%endmacro

%imacro LenStrHexToWord 2
; Just like LenStrToWord except always treated as hex value,
; string should never include a 0x prefix.
	%ifndef LenStrHexToWord_Required
		%define LenStrHexToWord_Required
		%define LenStrToWordHex_Required
	%endif
	pushm   cx, di
	DefReg  %1, cx, %2, di
    call    LenStrHexToWord_Proc
    popm    cx, di
%endmacro
