REM
REM This file is part of the ANSiMat project.
REM Copyright (C) Mateusz Viste
REM
REM IntToDWORD(IntValue) AS STRING
REM Converts an integer into a DWORD string (four-bytes value)
REM

FUNCTION IntToDWORD(BYREF IntValue AS INTEGER) AS STRING
  REM  Returns a string representing the integer number with a DWORD (4 bytes long)
  DIM AS UBYTE a, b, c, d
  DIM AS INTEGER RestValue = IntValue
  d = INT(IntValue/256^3)
  RestValue -= d * 256^3
  c = INT(RestValue/256^2)
  RestValue -= c * 256^2
  b = INT(RestValue/256)
  RestValue -= b * 256
  a = RestValue
  RETURN CHR(a,b,c,d)
END FUNCTION