REM
REM Saves the content of BigScreenBuffer to OutFile as a TGA graphic file.
REM Returns 0 if everything went fine, non-zero if a problem occured.
REM


FUNCTION SaveTgaFile(BYREF OutFile AS STRING, BYREF xlimit AS INTEGER, BYREF ylimit AS INTEGER) AS BYTE
  DIM AS BYTE Result = 0
  DIM AS UBYTE OldPixel, RleValue
  DIM AS INTEGER x, y, TgaFileHandler
  DIM AS STRING IdString = "Generated by ANSiMat v" & pVer
  DIM AS STRING RleEncodedDataLine
  TgaFileHandler = FREEFILE
  OPEN OutFile FOR OUTPUT AS #TgaFileHandler
  REM Write TGA header
  PRINT #TgaFileHandler, CHR(LEN(IdString));       ' Length of ID field (0 = none)
  PRINT #TgaFileHandler, CHR(1);                   ' Color map is included
  PRINT #TgaFileHandler, CHR(9);                   ' Image type (1=Uncomp. colormapped, 9=RLE colormapped)
  PRINT #TgaFileHandler, CHR(0,0);                 ' First index color
  PRINT #TgaFileHandler, CHR(0,1);                 ' Number of colors
  PRINT #TgaFileHandler, CHR(24);                  ' BPP depth of each color in the colormap
  PRINT #TgaFileHandler, CHR(0,0);                 ' xmin (?)
  PRINT #TgaFileHandler, CHR(0,0);                 ' ymin (?)
  PRINT #TgaFileHandler, IntToDoubleByte(xlimit);  ' xlimit
  PRINT #TgaFileHandler, IntToDoubleByte(ylimit);  ' ylimit
  PRINT #TgaFileHandler, CHR(8);                   ' BPP depth
  PRINT #TgaFileHandler, CHR(&b00100000);          ' Image descriptor (top left order)
  REM Write ID field
  PRINT #TgaFileHandler, IdString;
  REM Write BGR color map
  FOR x = 0 TO 255
    PRINT #TgaFileHandler, CHR((AnsiPallette(x)) AND &b11111111);        ' Write Blue value
    PRINT #TgaFileHandler, CHR((AnsiPallette(x) SHR 8) AND &b11111111);  ' Write Green value
    PRINT #TgaFileHandler, CHR((AnsiPallette(x) SHR 16) AND &b11111111); ' Write Red value
  NEXT x

  FOR y = 0 TO ylimit - 1
    OldPixel = BigScreenBuffer(0, y)
    RleValue = 1
    RleEncodedDataline = ""
    FOR x = 1 TO xlimit - 1
      IF BigScreenBuffer(x, y) = OldPixel AND RleValue < 128 THEN
          RleValue += 1
        ELSE
          RleEncodedDataline += CHR(RleValue + 127, OldPixel)
          RleValue = 1
          OldPixel = BigScreenBuffer(x, y)
      END IF
    NEXT x
    RleEncodedDataline += CHR(RleValue + 127, OldPixel) ' Add the last RLE pixel in buffer
    PRINT #TgaFileHandler, RleEncodedDataline;          ' Write RLE data
  NEXT y

  REM Write footer
  PRINT #TgaFileHandler, CHR(0,0,0,0);   ' Extension offset (zero if none)
  PRINT #TgaFileHandler, CHR(0,0,0,0);   ' Dev area offset (zero if none)
  PRINT #TgaFileHandler, "TRUEVISION-XFILE.";
  PRINT #TgaFileHandler, CHR(0);
  CLOSE #TgaFileHandler
  RETURN Result
END FUNCTION
