;
; bsum - a DOS tool that computes the BSD checksum of a file
;
; To be assembled with NASM: nasm -f bin -o bsum.com bsum.asm
;
; bsum is distributed under the terms of the MIT License, as listed below.
;
; Copyright (C) 2017 Mateusz Viste
;
; Permission is hereby granted, free of charge, to any person obtaining a copy
; of this software and associated documentation files (the "Software"), to
; deal in the Software without restriction, including without limitation the
; rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
; sell copies of the Software, and to permit persons to whom the Software is
; furnished to do so, subject to the following conditions:
;
; The above copyright notice and this permission notice shall be included in
; all copies or substantial portions of the Software.
;
; THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
; IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
; FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
; AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
; LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
; FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
; IN THE SOFTWARE.
;

CPU 8086           ; restrict instruction set to 8086
org 100h           ; COM file originates at 100h

; === CODE SEGMENT ===========================================================
section .text

; some initialization
push ds
pop es             ; I will use scasb which will read from es:di
cld                ; for all my string operations I will read forward
mov bp, 4C01h      ; I might use this value if I want to quit with error
; is there a (non-empty) argument?
mov ax, 0920h      ; I'll scan [81h] for non-space chars and later might call
                   ; INT 21h with subfunc 9 - setting both now to save a byte
mov di, 81h        ; it would be more readable to do mov di, 81h and then
mov cl, [di-1]     ; mov cl, [80h], but the contraption here is a byte shorter
xor ch, ch
mov bx, cx         ; save cx (arg len) into bx, I might need it again soon
repe scasb
jnz short gotarg

; no arg: print help screen and quit with err 01
;mov ah, 09h       ; no need - already set before
mov dx, MSGHLP
int 21h
xchg ax, bp        ; smaller than mov ax, 4C01h
int 21h

gotarg:
; add a 0 terminator to the arg, so it can be passed to INT 21h fopen()
mov [bx+81h], byte 0 ; reuse arg's length (good thing I had it saved)
; set dx to the start of the argument (ignore leading white spaces)
lea dx, [bx+80h]
sub dx, cx

; open file
mov ax, 3D00h      ; DOS 2+ "open file" (read-only)
int 21h
jnc short fileopenok
; error
mov ah, 09h
mov dx, MSGERR
int 21h
xchg ax, bp        ; smaller than doing a mov ax, 4C01h
int 21h
; all good (file opened)
fileopenok:
xchg ax, bx        ; save file handle to BX

xor di, di         ; di will hold the result
; read a byte (BX contains the file handle already)
nextbyte:
mov ah, 3Fh        ; DOS 2+ read from file
mov cx, 8192       ; read 8K of data...
mov dx, buff       ; ...and write it into buff
int 21h
jnc short readok

; I/O error -> close file and quit!
mov ah, 3Eh        ; DOS 2+ "close file" (bx contains the file handle already)
int 21h
mov ah, 09h        ; print error message
mov dx, MSGERR
int 21h
xchg ax, bp        ; smaller than doing a mov ax, 4C01h
int 21h

readok:
test ax, ax        ; look out for EOF (0 bytes read)
jz short eof

mov si, dx         ; SI points to read buffer

xchg ax, cx        ; CX contains the amount of bytes read, so I can reuse AX
xor ax, ax         ; reset AX (AL will be reused, but AH needs to be clean)
decodenext:
lodsb              ; load a byte from DS:SI into AL and INC SI
ror di, 1
add di, ax
loop decodenext

jmp short nextbyte

eof:
; close file (BX contains the file handle already)
mov ah, 3Eh
int 21h
; move the result to bx and print it out
mov bx, di
mov cx, 0404h      ; group the two MOVs below into one operation
;mov ch, 4         ; how many digits I need to print out
;mov cl, 4         ; will be used to shift (SHR/SHL) nibbles

printnextdigit:

mov al, bh         ; I'm only interested in the nibble at the left edge of BX
shr al, cl         ; CL is set to 4

; convert the AL nibble into an ASCII character of the range '0'..'F'
add al, '0'
cmp al, '9'
jbe short digitok
; otherwise it's an alfanumeric character (A..F)
add al, '@' - '9'
digitok:

xchg ax, dx        ; goal here is to do a mov dl, al (but xchg ax is shorter)
mov ah, 2          ; DOS 1+ "write DL to screen"
int 21h
shl bx, cl         ; move on to next nibble (CL is still set to 4, remember?)
dec ch
jnz short printnextdigit

; quit with exit code 0
xchg ax, bp        ; it's more efficient to load 4C01h followed by dec rather
dec ax             ; than to do a full-blown mov ax, 4C00h
int 21h

; === DATA SEGMENT ===========================================================
;section .data
; no need to specify a new section - tiny model implies DS == CS anyway (and I
; can save a byte or two on segment alignment)

MSGHLP db "bsum v1.0 - computes BSD checksum of file, MIT license", 13, 10, "Copyright (C) 2017 Mateusz Viste", 13, 10, 10, "Usage: bsum file$"
MSGERR db "ERROR$"

; === BSS SEGMENT ============================================================
section .bss
buff resb 8192
