/*
 * MIT License
 *
 * Copyright (c) 2024-2025 Davide Erbetta
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#include "rpnv.h"

void main(int argc, char *argv[])
{ 
    int result = 0; // if !=0 calc keep running in mainloop() function, otherwise goes to end program

    read_statelog(); // read state.log file if available, otherwise initialize program list registers

    start_datalog(); // start logging of keypressed, stack values, etc.

    initial_steps(); // set video mode

    init_calc_screen(); // draw the calculator layout

    init_mouse(); show_mouse(); double_speed_mouse(); // set mouse

    update_curpos(NOMOVE); // move button cursor to defaul position - ENTER key

    update_lcd(); // update the lcd screen with starting value

    while (result >= 0) result = main_loop(); // MAIN CALCULATOR LOOP

    hide_mouse(); // reset mouse

    closure_steps(); // return to default video mode

    fprintf(fp,"END LOG FILE"); // end data log file
    fclose(fp);

    save_statelog(); // save the content of memory registers and program list in state.log file to be read at next ON

    printf("RPNV Calculator version %s.\n",VERSION); // on exit print on screen calculator version used.
}
