; Blowfish encryption routine in Assembly
; Copyright (C) 2002 Davi T. Figueiredo
;
; Used in bf.e (version 2.02), available from http://www16.brinkster.com/davitf/
;
; Export or use of this program may be restricted in some countries.
; Please read bf.txt for more information and for its license terms
; and disclaimer.

; Variables:
; x_address - position in memory where the plain/encrypted data is stored
; p_address - position in memory where the p_array is stored
; s1_address, s2_address, s3_address and s4_address - positions in
; memory where the s_boxes are stored

; Variables with names like x_address_4 really mean x_address + 4. After
; being converted by Pete Eberlein's asm.ex, these values are changed in
; the Euphoria code.

; The order of the plaintext bytes is reversed before and after encryption
; because the words are stored in most- to least-significant byte order in
; Blowfish, and the calculations are performed in least- to most-significant
; byte order.


PUSH EAX                    ;save initial values
PUSH EBX
PUSH ECX
PUSH EDX

MOV ECX,p_address

;EAX will store xL and EBX will store xR
;Get xL and xR

MOV EDX,[x_address]     ; Copy xL from memory
MOV AL,DH               ; Invert the byte order in xL
MOV AH,DL
SHL EAX,16
SHR EDX,16
MOV AL,DH
MOV AH,DL

MOV EDX,[x_address_4]   ; Copy xR from memory
MOV BL,DH               ; Invert the byte order in xR
MOV BH,DL
SHL EBX,16
SHR EDX,16
MOV BL,DH
MOV BH,DL


Round:

XOR EAX,[ECX]        ; XOR xL with the appropriate entry in the p_array

PUSH EAX    ; Store xL
PUSH EBX    ; Store xR


; Calculate F(xL)
; Function F looks like this: Divide xL into four eight-bit
; quarters: a, b, c, and d. Then,
; F(xL) = ((S1[a] + S2[b] mod 2^32) XOR S3[c]) + S4[d] mod 2^32.

MOV EDX,EAX       ; Get A from xL, multiply it by four and add the address of the
SHR EDX,22        ; beggining of the s-box.
AND EDX,#000003FC ;
ADD EDX,s1_address; EDX now contains the address of the position of the entry in the s-box.
MOV EBX,[EDX]     ; EBX now contains S1[a]

MOV EDX,EAX       ; The same, but now with B
SHR EDX,14
AND EDX,#000003FC
ADD EDX,s2_address
ADD EBX,[EDX]     ; EBX now contains (S1[a] + S2[b] mod 2^32)

MOV EDX,EAX       ; The same, with C
SHR EDX,6
AND EDX,#000003FC
ADD EDX,s3_address
XOR EBX,[EDX]     ; EBX now contains (S1[a] + S2[b] mod 2^32) XOR S3[c]

MOV EDX,EAX       ; The same, with D
SHL EDX,2
AND EDX,#000003FC
ADD EDX,s4_address
ADD EBX,[EDX]     ; EBX now contains the result of function F


; Retrieve xL and xR from the stack
; xR will be read as xL and vice-versa (we are swapping xL and xR now)

POP EAX ; EAX will store xR
XOR EAX,EBX ; xor xR with the result of F
POP EBX ; all done, they are swapped


ADD ECX,4   ; Move to next P
CMP ECX,p_address_64    ; Finished all 16 rounds?
JB  Round           ; No, so go back for next round


XOR EAX,[ECX]   ;Do the last xorings
ADD ECX,4
XOR EBX,[ECX]


; xL and xR must be unswapped
; Save EBX in xL and EAX in xR, thus unswapping them

MOV DL,BH               ; Invert the byte order in EBX
MOV DH,BL               ; The result will be in EDX
SHL EDX,16
SHR EBX,16
MOV DL,BH
MOV DH,BL
MOV [x_address],EDX     ; Save xL

MOV DL,AH               ; Invert the byte order in EAX
MOV DH,AL               ; The result will be in EDX
SHL EDX,16
SHR EAX,16
MOV DL,AH
MOV DH,AL
MOV [x_address_4],EDX     ; Save xR


POP EDX                    ;restore initial values
POP ECX
POP EBX
POP EAX
RET                         ;end

