-- sha1_old.e - Secure Hash Algorithm (SHA-1) - 'clean' version 1.33
-- (slightly modified for use with Hide In Picture 2.2)
-- Copyright (C) 2002  Davi Tassinari de Figueiredo
--
-- If you wish to contact me, send an e-mail to davitf@eml.cc .
--
-- You can get the latest version of this program from my Euphoria page:
-- http://www16.brinkster.com/davitf/
--
--
-- License terms and disclaimer:
--
-- Permission is granted to anyone to use this software for any purpose,
-- including commercial applications, and to alter it and redistribute it
-- freely, subject to the following restrictions:
--
-- 1. The origin of this software must not be misrepresented; you must not
--    claim that you wrote the original software or remove the original
--    authors' names.
-- 2. Altered source versions must be plainly marked as such, and must not
--    be misrepresented as being the original software.
-- 3. All source distributions, with or without modifications, must be
--    distributed under this license. You may also opt to distribute the
--    software under the GNU General Public License, version 2 or (at your
--    option) any later version, in which case you should replace this
--    notice with an appropriate one. If this software's source code is
--    distributed as part of a larger product, this item does not apply to
--    the rest of the product.
-- 4. If you use this software in a product, an acknowledgment in the
--    product documentation is required. If the source code for the product
--    is not freely distributed, you must include information on how to
--    freely obtain the original software's source code.
--
-- This software is provided 'as-is', without any express or implied
-- warranty.  In no event will the authors be held liable for any damages
-- arising from the use of this software.
--
-- If you want to distribute this software in a way not allowed by this
-- license, or distribute the source under different license terms, contact
-- the authors for permission.


-- 'General-purpose' routines

-- Reversed versions of int_to_bytes and bytes_to_int
-- (most-significant byte first)

function rev_int_to_bytes(atom x)
    -- adapted and optimized from int_to_bytes, in machine.e

    integer a,b,c

    a = and_bits(x, #FF)
    x = floor(x / #100)
    b = and_bits(x, #FF)
    x = floor(x / #100)
    c = and_bits(x, #FF)
    x = floor(x / #100)
    return {x,c,b,a}
end function

function rev_bytes_to_int(sequence s)
    -- adapted from bytes_to_int, in machine.e
    return s[4] +
	   s[3] * #100 +
	   s[2] * #10000 +
	   s[1] * #1000000
end function


-- The bitwise functions in Euphoria (xor_bits, and_bits, or_bits, not_bits)
-- return signed numbers. The following functions return unsigned numbers.

function uxor(atom data1,atom data2)
    atom result
    result=xor_bits(data1,data2)
    if result<0 then return result+#100000000 else return result end if
end function

function uand(atom data1,atom data2)
    atom result
    result=and_bits(data1,data2)
    if result<0 then return result+#100000000 else return result end if
end function

function uor(atom data1,atom data2)
    atom result
    result=or_bits(data1,data2)
    if result<0 then return result+#100000000 else return result end if
end function

function unot(atom data)
    atom result
    result=not_bits(data)
    if result<0 then return result+#100000000 else return result end if
end function


constant power_2={       #1,       #2,       #4,       #8,  -- This table
			#10,      #20,      #40,      #80,  -- is used to
		       #100,     #200,     #400,     #800,  -- avoid using
		      #1000,    #2000,    #4000,    #8000,  -- power(2,n)
		     #10000,   #20000,   #40000,   #80000,  -- in rol(),
		    #100000,  #200000,  #400000,  #800000,  -- making the
		   #1000000, #2000000, #4000000, #8000000,  -- routine a bit
		  #10000000,#20000000,#40000000,#80000000,  -- faster.
		 #100000000}

function rol(atom word,integer bits)
    -- rol() rotates the bits of a word (32-bit number)
    -- the specified number of bits
    -- This function is not really used in the program,
    -- but I left it here in case you want to play with it.
    return remainder(word*power_2[bits+1],#100000000)+floor(word/power_2[33-bits])
end function

-- End of 'general-purpose' routines



constant c_H_words={#67452301,#EFCDAB89,#98BADCFE,#10325476,#C3D2E1F0}
sequence H_words


function divide_in_words(sequence message)
    -- Divides the string into words (32-bit numbers)

    sequence words
    words=repeat(0,length(message)/4)
    for word=1 to length(message)/4 do
	words[word]=rev_bytes_to_int(message[word*4-3..word*4])
    end for
    return words

end function


procedure process_block(sequence block)
    -- Updates the H words according to the contents of the block

    atom a,b,c,d,e,temp
    sequence W_words

    -- Initialize the W sequence values
    W_words=repeat(0,80)
    W_words[1..16]=divide_in_words(block)

    for word=17 to 80 do
	temp=
	uxor(xor_bits(W_words[word-3],W_words[word-8]),
	xor_bits(W_words[word-14],W_words[word-16]))

	-- W_words[word] = rol(temp,1)
	W_words[word] = remainder(temp*2,#100000000)+(temp>=#80000000)

    end for

    -- Initialize the buffer
    a=H_words[1]
    b=H_words[2]
    c=H_words[3]
    d=H_words[4]
    e=H_words[5]

    -- Process the block
    -- Round 1
    for step=1 to 20 do

	-- temp = rol(a,5) +
	temp = remainder(a*#20,#100000000)+floor(a/#8000000) +

	-- (B and C) or ((not B) and D)
	or_bits(and_bits(b,c),and_bits(not_bits(b),d))+
	e+W_words[step]+#5A827999

	if temp>#FFFFFFFF then temp=remainder(temp,#100000000)
	elsif temp<0 then temp=temp+#100000000 end if

	e=d  d=c
	-- c = rol(b,30)
	c = remainder(b*#40000000,#100000000)+floor(b/#4)
	b=a  a=temp

    end for

    -- Round 2
    for step=21 to 40 do

	-- temp = rol(a,5) +
	temp=   remainder(a*#20,#100000000)+floor(a/#8000000) +

	-- B xor C xor D
	xor_bits(b,xor_bits(c,d))+
	e+W_words[step]+#6ED9EBA1

	if temp>#FFFFFFFF then temp=remainder(temp,#100000000)
	elsif temp<0 then temp=temp+#100000000 end if

	e=d  d=c
	-- c = rol(b,30)
	c=remainder(b*#40000000,#100000000)+floor(b/#4) -- rol(b,30)
	b=a  a=temp
    end for

    -- Round 3
    for step=41 to 60 do

	-- temp = rol(a,5) +
	temp=   remainder(a*#20,#100000000)+floor(a/#8000000) +

	-- (B and C) or (B and D) or (C and D)
	or_bits(and_bits(b,c),or_bits(and_bits(b,d),and_bits(c,d)))+
	e+W_words[step]+#8F1BBCDC

	if temp>#FFFFFFFF then temp=remainder(temp,#100000000)
	elsif temp<0 then temp=temp+#100000000 end if

	e=d  d=c
	-- c = rol(b,30)
	c=remainder(b*#40000000,#100000000)+floor(b/#4)
	b=a  a=temp
    end for


    -- Round 4
    for step=61 to 80 do

	-- temp = rol(a,5) +
	temp=   remainder(a*#20,#100000000)+floor(a/#8000000) +

	-- B xor C xor D
	xor_bits(b,xor_bits(c,d))+
	e+W_words[step]+#CA62C1D6

	if temp>#FFFFFFFF then temp=remainder(temp,#100000000)
	elsif temp<0 then temp=temp+#100000000 end if

	e=d  d=c
	-- c = rol(b,30)
	c=remainder(b*#40000000,#100000000)+floor(b/#4)
	b=a  a=temp
    end for


    -- Update the H words
    H_words[1]=remainder(H_words[1]+a,#100000000)
    H_words[2]=remainder(H_words[2]+b,#100000000)
    H_words[3]=remainder(H_words[3]+c,#100000000)
    H_words[4]=remainder(H_words[4]+d,#100000000)
    H_words[5]=remainder(H_words[5]+e,#100000000)

end procedure


function pad_message(sequence message)
    -- Add bytes to the end of the message so it can be divided
    -- in an exact number of 64-byte blocks.

    atom bytes_to_add
    bytes_to_add=64-remainder(length(message)+9,64)
    if bytes_to_add=64 then bytes_to_add=0 end if

    message=message&128&repeat(0,bytes_to_add)&
      {0,0,0,0}&rev_int_to_bytes(length(message)*8)

    return message
end function


global function sha_1(sequence message)
    -- Given a string, returns a 20-byte hash of it.

    H_words=c_H_words   -- Initialize the H words

    message=pad_message(and_bits(message,#FF)) -- Add bytes to the message
		-- and discard high-order bits

    -- Process each 64-byte block
    for pos_in_message=1 to length(message) by 64 do

       process_block(message[pos_in_message..pos_in_message+63])
    end for

    -- Convert hash into bytes
    return rev_int_to_bytes(H_words[1])&    -- Return the hash
	   rev_int_to_bytes(H_words[2])&
	   rev_int_to_bytes(H_words[3])&
	   rev_int_to_bytes(H_words[4])&
	   rev_int_to_bytes(H_words[5])

end function

