# Make file for PG
# Author: BAHCL   e-mail:
# Freeware under GNU GPL version 2
#
# How to use:
#      make -fpg.mak [-D[xxx]] -Dtc=the_path_of_TurboC
# e.g. make -fpg.mak -Dtc=c:\tc\
#
#
# NASM the Net Assembler
asm=nasm

all: pg.exe svtxt.com svhex.com

!if $d(COLOR)
color=USE_COLOR_MODE
!endif

!if $d(GNU)
gnu=SHOW_GNU_COPYING
!endif

pg.exe: pg.obj pgasm.obj
    $(tc)tlink /c $(tc)lib\c0s pg pgasm,pg,,$(tc)lib\cs

pg.obj: pg.c pg.h
    $(tc)tcc -D$(color) -D$(gnu) -c pg.c

pgasm.obj: pgasm.asm pg.c
    $(asm) -fobj pgasm.asm -opgasm.obj

svtxt.com: svtxt.asm
    $(asm) -fbin svtxt.asm -osvtxt.com

svhex.com: svhex.asm
    $(asm) -fbin svhex.asm -osvhex.com


clean:
   del pg.exe
   del pg*.obj
   del pg*.map
   del sv*.com
