unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, ExtCtrls, Gradpan, Buttons, Menus;

type
  TForm1 = class(TForm)
    Edit1: TEdit;
    FontDialog1: TFontDialog;
    Edit2: TEdit;
    Button2: TButton;
    Edit3: TEdit;
    Edit4: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    UpDown1: TUpDown;
    UpDown2: TUpDown;
    Button3: TButton;
    BitBtn1: TBitBtn;
    SaveDialog1: TSaveDialog;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    SelectFont1: TMenuItem;
    SelectFile1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    Help1: TMenuItem;
    Convert: TMenuItem;
    Help2: TMenuItem;
    About1: TMenuItem;
    procedure BitBtn1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure About1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  F1: file;

implementation

{$R *.DFM}

procedure TForm1.BitBtn1Click(Sender: TObject);
Var
  MyTRect: TRect;
  Buffer: array [1..16] of byte;
  WordBuffer: word;
  X,Y: byte;
  Ascii: byte;
  StringStart, StringEnd: string;
  AsciiStart, AsciiEnd: integer;
  Code: Integer;
begin
  if Edit1.Text='' then
  begin
    MessageDlg('Oops! No output file selected!', mtError, [mbOK], 0);
    Exit;
  end;
  if Edit2.Text='' then
  begin
    MessageDlg('Oops! No font selected!', mtError, [mbOK], 0);
    Exit;
  end;

  AssignFile(F1, Edit1.Text);
  Rewrite(F1,1);
  StringStart:=Edit3.Text;
  StringEnd:=Edit4.Text;
  Val(StringStart, AsciiStart, Code);
  Val(StringEnd, AsciiEnd, Code);
  WordBuffer:=AsciiEnd-AsciiStart;
  BlockWrite(F1, WordBuffer, 1);
  WordBuffer:=AsciiStart;
  BlockWrite(F1, WordBuffer, 1);
  for Ascii:=AsciiStart to AsciiEnd do
  begin
    Canvas.Pen.Style:=psSolid;
    Canvas.Pen.Color:=65535;
    Canvas.Brush.Style:=bsSolid;
    Canvas.Rectangle(10,10,19,27);
    Canvas.FloodFill(12,12,65535, fsBorder);
    Canvas.Pen.Color:=0;
    MyTRect:=Rect(10,10,18,26);
    Canvas.TextRect(MyTRect, 10,10, chr(Ascii));
    for Y:=1 to 16 do
      Buffer[Y]:=0;
    for Y:= 1 to 16 do
      for X:=0 to 7 do
      begin
        if Canvas.Pixels[X+9, Y+10]=0 then
          Buffer[Y]:=Buffer[Y] or 1
        else
          Buffer[Y]:=Buffer[Y] or 0;
        if X<>7 then
           Buffer[Y]:=Buffer[Y] SHL 1;
      end;
    BlockWrite(F1, Buffer, 16);
  end;
  CloseFile(F1);
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  if FontDialog1.Execute then
  begin
    Edit2.Text:=FontDialog1.Font.Name;
    Form1.Canvas.Font.Name:=FontDialog1.Font.Name;
    Form1.Canvas.Font.Size:=FontDialog1.Font.Size;
    Form1.Canvas.Font.Style:=FontDialog1.Font.Style;
  end;

end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  if SaveDialog1.Execute then
  begin
    Edit1.Text:=SaveDialog1.FileName;  
  end;
end;

procedure TForm1.About1Click(Sender: TObject);
begin
  MessageDlg('TTF2FNT Truetype to DOS font coverter'+chr(13)+'GPL Kurt Zammit 2001', mtCustom, [mbOK], 0);
end;

end.
